/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d.print;

import com.sun.glass.ui.Application;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.print.PrintHelper;
import com.sun.javafx.print.PrinterImpl;
import com.sun.javafx.print.PrinterJobImpl;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.j2d.print.J2DPrinter;
import com.sun.prism.j2d.print.J2DPrinterJob$1;
import com.sun.prism.j2d.print.J2DPrinterJob$J2DPageable;
import com.sun.prism.j2d.print.J2DPrinterJob$PageDialogRunnable;
import com.sun.prism.j2d.print.J2DPrinterJob$PrintDialogRunnable;
import com.sun.prism.j2d.print.J2DPrinterJob$PrintJobRunnable;
import java.awt.GraphicsEnvironment;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import javafx.print.Collation;
import javafx.print.JobSettings;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.PageRange;
import javafx.print.Paper;
import javafx.print.PaperSource;
import javafx.print.PrintColor;
import javafx.print.PrintQuality;
import javafx.print.PrintResolution;
import javafx.print.PrintSides;
import javafx.print.Printer;
import javafx.print.Printer$MarginType;
import javafx.print.PrinterAttributes;
import javafx.scene.Node;
import javafx.stage.Window;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;

public class J2DPrinterJob
implements PrinterJobImpl {
    javafx.print.PrinterJob fxPrinterJob;
    PrinterJob pJob2D;
    Printer fxPrinter;
    J2DPrinter j2dPrinter;
    private JobSettings settings;
    private PrintRequestAttributeSet printReqAttrSet;
    private volatile Object elo = null;
    private static Class onTopClass;
    private boolean jobRunning = false;
    private boolean jobError = false;
    private boolean jobDone = false;
    private boolean jobCanceled = false;
    private J2DPrinterJob$J2DPageable j2dPageable = null;
    private Object monitor = new Object();

    PrintRequestAttribute getAlwaysOnTop(long l2) {
        return AccessController.doPrivileged(() -> {
            PrintRequestAttribute printRequestAttribute = null;
            try {
                if (onTopClass == null) {
                    onTopClass = Class.forName("javax.print.attribute.standard.DialogOwner");
                }
                if (l2 == 0L) {
                    Constructor constructor = onTopClass.getConstructor(new Class[0]);
                    printRequestAttribute = (PrintRequestAttribute)constructor.newInstance(new Object[0]);
                } else {
                    printRequestAttribute = J2DPrinterJob.getAlwaysOnTop(onTopClass, l2);
                }
            }
            catch (Throwable throwable) {}
            return printRequestAttribute;
        });
    }

    private static native PrintRequestAttribute getAlwaysOnTop(Class var0, long var1);

    public J2DPrinterJob(javafx.print.PrinterJob printerJob) {
        this.fxPrinterJob = printerJob;
        this.fxPrinter = this.fxPrinterJob.getPrinter();
        this.j2dPrinter = this.getJ2DPrinter(this.fxPrinter);
        this.settings = this.fxPrinterJob.getJobSettings();
        this.pJob2D = PrinterJob.getPrinterJob();
        try {
            this.pJob2D.setPrintService(this.j2dPrinter.getService());
        }
        catch (PrinterException printerException) {}
        this.printReqAttrSet = new HashPrintRequestAttributeSet();
        this.printReqAttrSet.add(DialogTypeSelection.NATIVE);
        this.j2dPageable = new J2DPrinterJob$J2DPageable(this);
        this.pJob2D.setPageable(this.j2dPageable);
    }

    private void setEnabledState(Window object, boolean bl2) {
        if (object == null) {
            return;
        }
        if ((object = WindowHelper.getPeer((Window)object)) == null) {
            return;
        }
        Application.invokeAndWait(() -> J2DPrinterJob.lambda$setEnabledState$2((TKStage)object, bl2));
    }

    @Override
    public boolean showPrintDialog(Window window) {
        boolean bl2;
        if (this.jobRunning || this.jobDone || this.jobCanceled) {
            return false;
        }
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        if (onTopClass != null) {
            this.printReqAttrSet.remove(onTopClass);
        }
        if (window != null) {
            PrintRequestAttribute printRequestAttribute;
            long l2 = 0L;
            if (PlatformUtil.isWindows()) {
                l2 = WindowHelper.getPeer(window).getRawHandle();
            }
            if ((printRequestAttribute = this.getAlwaysOnTop(l2)) != null) {
                this.printReqAttrSet.add(printRequestAttribute);
            }
        }
        this.syncSettingsToAttributes();
        try {
            this.setEnabledState(window, false);
            if (!Toolkit.getToolkit().isFxUserThread()) {
                bl2 = this.pJob2D.printDialog(this.printReqAttrSet);
            } else {
                if (!Toolkit.getToolkit().canStartNestedEventLoop()) {
                    throw new IllegalStateException("Printing is not allowed during animation or layout processing");
                }
                bl2 = this.showPrintDialogWithNestedLoop(window);
            }
            if (bl2) {
                this.updateSettingsFromDialog();
            }
        }
        finally {
            this.setEnabledState(window, true);
        }
        return bl2;
    }

    private boolean showPrintDialogWithNestedLoop(Window object) {
        object = new J2DPrinterJob$PrintDialogRunnable(this);
        Thread thread = new Thread((Runnable)object, "FX Print Dialog Thread");
        thread.start();
        object = Toolkit.getToolkit().enterNestedEventLoop(object);
        boolean bl2 = false;
        try {
            bl2 = (Boolean)object;
        }
        catch (Exception exception) {}
        return bl2;
    }

    @Override
    public boolean showPageDialog(Window window) {
        boolean bl2;
        if (this.jobRunning || this.jobDone || this.jobCanceled) {
            return false;
        }
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        if (onTopClass != null) {
            this.printReqAttrSet.remove(onTopClass);
        }
        if (window != null) {
            PrintRequestAttribute printRequestAttribute;
            long l2 = 0L;
            if (PlatformUtil.isWindows()) {
                l2 = WindowHelper.getPeer(window).getRawHandle();
            }
            if ((printRequestAttribute = this.getAlwaysOnTop(l2)) != null) {
                this.printReqAttrSet.add(printRequestAttribute);
            }
        }
        this.syncSettingsToAttributes();
        try {
            this.setEnabledState(window, false);
            if (!Toolkit.getToolkit().isFxUserThread()) {
                PageFormat pageFormat = this.pJob2D.pageDialog(this.printReqAttrSet);
                bl2 = pageFormat != null;
            } else {
                if (!Toolkit.getToolkit().canStartNestedEventLoop()) {
                    throw new IllegalStateException("Printing is not allowed during animation or layout processing");
                }
                bl2 = this.showPageDialogFromNestedLoop(window);
            }
        }
        finally {
            this.setEnabledState(window, true);
        }
        if (bl2) {
            this.updateSettingsFromDialog();
        }
        return bl2;
    }

    private boolean showPageDialogFromNestedLoop(Window object) {
        object = new J2DPrinterJob$PageDialogRunnable(this);
        Thread thread = new Thread((Runnable)object, "FX Page Setup Dialog Thread");
        thread.start();
        object = Toolkit.getToolkit().enterNestedEventLoop(object);
        boolean bl2 = false;
        try {
            bl2 = (Boolean)object;
        }
        catch (Exception exception) {}
        return bl2;
    }

    private void updateJobName() {
        String string = this.pJob2D.getJobName();
        if (!string.equals(this.settings.getJobName())) {
            this.settings.setJobName(string);
        }
    }

    private void updateOutputFile() {
        Destination destination = (Destination)this.printReqAttrSet.get(Destination.class);
        if (destination != null) {
            this.settings.setOutputFile(destination.getURI().getPath());
            return;
        }
        this.settings.setOutputFile("");
    }

    private void updateCopies() {
        int n2 = this.pJob2D.getCopies();
        if (this.settings.getCopies() != n2) {
            this.settings.setCopies(n2);
        }
    }

    private void updatePageRanges() {
        Object object = (PageRanges)this.printReqAttrSet.get(PageRanges.class);
        if (object != null) {
            int[][] nArray = ((SetOfIntegerSyntax)object).getMembers();
            object = nArray;
            if (nArray.length == 1) {
                PageRange pageRange = new PageRange((int)object[0][0], (int)object[0][1]);
                this.settings.setPageRanges(pageRange);
                return;
            }
            if (((Object)object).length > 0) {
                try {
                    ArrayList<PageRange> arrayList = new ArrayList<PageRange>();
                    Object object2 = false;
                    for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                        Object object3 = object[i2][0];
                        Object object4 = object[i2][1];
                        if (object3 <= object2 || object4 < object3) {
                            return;
                        }
                        object2 = object4;
                        arrayList.add(new PageRange((int)object3, (int)object4));
                    }
                    this.settings.setPageRanges(arrayList.toArray(new PageRange[0]));
                    return;
                }
                catch (Exception exception) {}
            }
        }
    }

    private void updateSides() {
        Sides sides = (Sides)this.printReqAttrSet.get(Sides.class);
        if (sides == null) {
            sides = (Sides)this.j2dPrinter.getService().getDefaultAttributeValue(Sides.class);
        }
        if (sides == Sides.ONE_SIDED) {
            this.settings.setPrintSides(PrintSides.ONE_SIDED);
            return;
        }
        if (sides == Sides.DUPLEX) {
            this.settings.setPrintSides(PrintSides.DUPLEX);
            return;
        }
        if (sides == Sides.TUMBLE) {
            this.settings.setPrintSides(PrintSides.TUMBLE);
        }
    }

    private void updateCollation() {
        SheetCollate sheetCollate = (SheetCollate)this.printReqAttrSet.get(SheetCollate.class);
        if (sheetCollate == null) {
            sheetCollate = this.j2dPrinter.getDefaultSheetCollate();
        }
        if (sheetCollate == SheetCollate.UNCOLLATED) {
            this.settings.setCollation(Collation.UNCOLLATED);
            return;
        }
        this.settings.setCollation(Collation.COLLATED);
    }

    private void updateColor() {
        Chromaticity chromaticity = (Chromaticity)this.printReqAttrSet.get(Chromaticity.class);
        if (chromaticity == null) {
            chromaticity = this.j2dPrinter.getDefaultChromaticity();
        }
        if (chromaticity == Chromaticity.COLOR) {
            this.settings.setPrintColor(PrintColor.COLOR);
            return;
        }
        this.settings.setPrintColor(PrintColor.MONOCHROME);
    }

    private void updatePrintQuality() {
        javax.print.attribute.standard.PrintQuality printQuality = (javax.print.attribute.standard.PrintQuality)this.printReqAttrSet.get(javax.print.attribute.standard.PrintQuality.class);
        if (printQuality == null) {
            printQuality = this.j2dPrinter.getDefaultPrintQuality();
        }
        if (printQuality == javax.print.attribute.standard.PrintQuality.DRAFT) {
            this.settings.setPrintQuality(PrintQuality.DRAFT);
            return;
        }
        if (printQuality == javax.print.attribute.standard.PrintQuality.HIGH) {
            this.settings.setPrintQuality(PrintQuality.HIGH);
            return;
        }
        this.settings.setPrintQuality(PrintQuality.NORMAL);
    }

    private void updatePrintResolution() {
        PrinterResolution printerResolution = (PrinterResolution)this.printReqAttrSet.get(PrinterResolution.class);
        if (printerResolution == null) {
            printerResolution = this.j2dPrinter.getDefaultPrinterResolution();
        }
        int n2 = printerResolution.getCrossFeedResolution(100);
        int n3 = printerResolution.getFeedResolution(100);
        this.settings.setPrintResolution(PrintHelper.createPrintResolution(n2, n3));
    }

    private void updatePageLayout() {
        Object object = (Media)this.printReqAttrSet.get(Media.class);
        object = this.j2dPrinter.getPaperForMedia((Media)object);
        Object object2 = (OrientationRequested)this.printReqAttrSet.get(OrientationRequested.class);
        object2 = J2DPrinter.reverseMapOrientation((OrientationRequested)object2);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)this.printReqAttrSet.get(MediaPrintableArea.class);
        if (mediaPrintableArea == null) {
            object = this.fxPrinter.createPageLayout((Paper)object, (PageOrientation)((Object)object2), Printer$MarginType.DEFAULT);
        } else {
            double d2 = ((Paper)object).getWidth();
            double d3 = ((Paper)object).getHeight();
            double d4 = mediaPrintableArea.getX(25400) * 72.0f;
            double d5 = mediaPrintableArea.getY(25400) * 72.0f;
            double d6 = mediaPrintableArea.getWidth(25400) * 72.0f;
            double d7 = mediaPrintableArea.getHeight(25400) * 72.0f;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            switch (J2DPrinterJob$1.$SwitchMap$javafx$print$PageOrientation[((Enum)object2).ordinal()]) {
                case 1: {
                    d8 = d4;
                    d9 = d2 - d4 - d6;
                    d10 = d5;
                    d11 = d3 - d5 - d7;
                    break;
                }
                case 2: {
                    d8 = d2 - d4 - d6;
                    d9 = d4;
                    d10 = d3 - d5 - d7;
                    d11 = d5;
                    break;
                }
                case 3: {
                    d8 = d5;
                    d9 = d3 - d5 - d7;
                    d10 = d2 - d4 - d6;
                    d11 = d4;
                    break;
                }
                case 4: {
                    d8 = d3 - d5 - d7;
                    d10 = d4;
                    d9 = d5;
                    d11 = d2 - d4 - d6;
                }
            }
            if (d8 < 0.01) {
                d8 = 0.0;
            }
            if (d9 < 0.01) {
                d9 = 0.0;
            }
            if (d10 < 0.01) {
                d10 = 0.0;
            }
            if (d11 < 0.01) {
                d11 = 0.0;
            }
            object = this.fxPrinter.createPageLayout((Paper)object, (PageOrientation)((Object)object2), d8, d9, d10, d11);
        }
        this.settings.setPageLayout((PageLayout)object);
    }

    private void updatePaperSource() {
        Object object = (Media)this.printReqAttrSet.get(Media.class);
        if (object instanceof MediaTray && (object = this.j2dPrinter.getPaperSource((MediaTray)object)) != null) {
            this.settings.setPaperSource((PaperSource)object);
        }
    }

    private Printer getFXPrinterForService(PrintService printService) {
        Object object = Printer.getAllPrinters();
        object = object.iterator();
        while (object.hasNext()) {
            Printer printer = (Printer)object.next();
            Object object2 = (J2DPrinter)PrintHelper.getPrinterImpl(printer);
            if (!(object2 = ((J2DPrinter)object2).getService()).equals(printService)) continue;
            return printer;
        }
        return this.fxPrinter;
    }

    @Override
    public void setPrinterImpl(PrinterImpl printerImpl) {
        this.j2dPrinter = (J2DPrinter)printerImpl;
        this.fxPrinter = this.j2dPrinter.getPrinter();
        try {
            this.pJob2D.setPrintService(this.j2dPrinter.getService());
            return;
        }
        catch (PrinterException printerException) {
            return;
        }
    }

    @Override
    public PrinterImpl getPrinterImpl() {
        return this.j2dPrinter;
    }

    private J2DPrinter getJ2DPrinter(Printer printer) {
        return (J2DPrinter)PrintHelper.getPrinterImpl(printer);
    }

    public Printer getPrinter() {
        return this.fxPrinter;
    }

    public void setPrinter(Printer printer) {
        this.fxPrinter = printer;
        this.j2dPrinter = this.getJ2DPrinter(printer);
        try {
            this.pJob2D.setPrintService(this.j2dPrinter.getService());
            return;
        }
        catch (PrinterException printerException) {
            return;
        }
    }

    private void updatePrinter() {
        PrintService printService;
        Object object = this.j2dPrinter.getService();
        if (object.equals(printService = this.pJob2D.getPrintService())) {
            return;
        }
        object = this.getFXPrinterForService(printService);
        this.fxPrinterJob.setPrinter((Printer)object);
    }

    private void updateSettingsFromDialog() {
        this.updatePrinter();
        this.updateJobName();
        this.updateOutputFile();
        this.updateCopies();
        this.updatePageRanges();
        this.updateSides();
        this.updateCollation();
        this.updatePageLayout();
        this.updatePaperSource();
        this.updateColor();
        this.updatePrintQuality();
        this.updatePrintResolution();
    }

    private void syncSettingsToAttributes() {
        this.syncJobName();
        this.syncOutputFile();
        this.syncCopies();
        this.syncPageRanges();
        this.syncSides();
        this.syncCollation();
        this.syncPageLayout();
        this.syncPaperSource();
        this.syncColor();
        this.syncPrintQuality();
        this.syncPrintResolution();
    }

    private void syncJobName() {
        this.pJob2D.setJobName(this.settings.getJobName());
    }

    private void syncOutputFile() {
        this.printReqAttrSet.remove(Destination.class);
        Object object = this.settings.getOutputFile();
        if (object != null && !((String)object).isEmpty()) {
            object = new File((String)object).toURI();
            object = new Destination((URI)object);
            this.printReqAttrSet.add((Attribute)object);
        }
    }

    private void syncCopies() {
        this.pJob2D.setCopies(this.settings.getCopies());
        this.printReqAttrSet.add(new Copies(this.settings.getCopies()));
    }

    private void syncPageRanges() {
        this.printReqAttrSet.remove(PageRanges.class);
        PageRange[] pageRangeArray = this.settings.getPageRanges();
        if (pageRangeArray != null && pageRangeArray.length > 0) {
            int n2 = pageRangeArray.length;
            int[][] nArray = new int[n2][2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2][0] = pageRangeArray[i2].getStartPage();
                nArray[i2][1] = pageRangeArray[i2].getEndPage();
            }
            this.printReqAttrSet.add(new PageRanges(nArray));
        }
    }

    private void syncSides() {
        Sides sides = Sides.ONE_SIDED;
        PrintSides printSides = this.settings.getPrintSides();
        if (printSides == PrintSides.DUPLEX) {
            sides = Sides.DUPLEX;
        } else if (printSides == PrintSides.TUMBLE) {
            sides = Sides.TUMBLE;
        }
        this.printReqAttrSet.add(sides);
    }

    private void syncCollation() {
        if (this.settings.getCollation() == Collation.UNCOLLATED) {
            this.printReqAttrSet.add(SheetCollate.UNCOLLATED);
            return;
        }
        this.printReqAttrSet.add(SheetCollate.COLLATED);
    }

    private void syncPageLayout() {
        Object object = this.settings.getPageLayout();
        PageOrientation pageOrientation = ((PageLayout)object).getPageOrientation();
        this.printReqAttrSet.add(J2DPrinter.mapOrientation(pageOrientation));
        double d2 = ((PageLayout)object).getPaper().getWidth();
        double d3 = ((PageLayout)object).getPaper().getHeight();
        float f2 = (float)(d2 / 72.0);
        float f3 = (float)(d3 / 72.0);
        MediaSizeName mediaSizeName = MediaSize.findMedia(f2, f3, 25400);
        if (mediaSizeName == null) {
            mediaSizeName = MediaSizeName.NA_LETTER;
        }
        this.printReqAttrSet.add(mediaSizeName);
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = d2;
        double d7 = d3;
        switch (pageOrientation) {
            case PORTRAIT: {
                d4 = ((PageLayout)object).getLeftMargin();
                d5 = ((PageLayout)object).getTopMargin();
                d6 = d2 - d4 - ((PageLayout)object).getRightMargin();
                d7 = d3 - d5 - ((PageLayout)object).getBottomMargin();
                break;
            }
            case REVERSE_PORTRAIT: {
                d4 = ((PageLayout)object).getRightMargin();
                d5 = ((PageLayout)object).getBottomMargin();
                d6 = d2 - d4 - ((PageLayout)object).getLeftMargin();
                d7 = d3 - d5 - ((PageLayout)object).getTopMargin();
                break;
            }
            case LANDSCAPE: {
                d4 = ((PageLayout)object).getBottomMargin();
                d5 = ((PageLayout)object).getLeftMargin();
                d6 = d2 - d4 - ((PageLayout)object).getTopMargin();
                d7 = d3 - d5 - ((PageLayout)object).getRightMargin();
                break;
            }
            case REVERSE_LANDSCAPE: {
                d4 = ((PageLayout)object).getTopMargin();
                d5 = ((PageLayout)object).getRightMargin();
                d6 = d2 - d4 - ((PageLayout)object).getBottomMargin();
                d7 = d3 - d5 - ((PageLayout)object).getLeftMargin();
            }
        }
        object = new MediaPrintableArea((float)(d4 /= 72.0), (float)(d5 /= 72.0), (float)(d6 /= 72.0), (float)(d7 /= 72.0), 25400);
        this.printReqAttrSet.add((Attribute)object);
    }

    private void syncPaperSource() {
        Object object = (Media)this.printReqAttrSet.get(Media.class);
        if (object != null && object instanceof MediaTray) {
            this.printReqAttrSet.remove(Media.class);
        }
        if (!(object = this.settings.getPaperSource()).equals(this.j2dPrinter.defaultPaperSource()) && (object = this.j2dPrinter.getTrayForPaperSource((PaperSource)object)) != null) {
            this.printReqAttrSet.add((Attribute)object);
        }
    }

    private void syncColor() {
        if (this.settings.getPrintColor() == PrintColor.MONOCHROME) {
            this.printReqAttrSet.add(Chromaticity.MONOCHROME);
            return;
        }
        this.printReqAttrSet.add(Chromaticity.COLOR);
    }

    private void syncPrintQuality() {
        Object object = this.settings.getPrintQuality();
        object = object == PrintQuality.DRAFT ? javax.print.attribute.standard.PrintQuality.DRAFT : (object == PrintQuality.HIGH ? javax.print.attribute.standard.PrintQuality.HIGH : javax.print.attribute.standard.PrintQuality.NORMAL);
        this.printReqAttrSet.add((Attribute)object);
    }

    private void syncPrintResolution() {
        int n2;
        PrintService printService = this.pJob2D.getPrintService();
        if (!printService.isAttributeCategorySupported(PrinterResolution.class)) {
            this.printReqAttrSet.remove(PrinterResolution.class);
            return;
        }
        Object object = (PrinterResolution)this.printReqAttrSet.get(PrinterResolution.class);
        if (object != null && !printService.isAttributeValueSupported((Attribute)object, null, null)) {
            this.printReqAttrSet.remove(PrinterResolution.class);
        }
        if ((object = this.settings.getPrintResolution()) == null) {
            return;
        }
        int n3 = ((PrintResolution)object).getCrossFeedResolution();
        PrinterResolution printerResolution = new PrinterResolution(n3, n2 = ((PrintResolution)object).getFeedResolution(), 100);
        if (!printService.isAttributeValueSupported(printerResolution, null, null)) {
            return;
        }
        this.printReqAttrSet.add(printerResolution);
    }

    @Override
    public PageLayout validatePageLayout(PageLayout pageLayout) {
        boolean bl2 = false;
        PrinterAttributes printerAttributes = this.fxPrinter.getPrinterAttributes();
        Paper paper = pageLayout.getPaper();
        if (!printerAttributes.getSupportedPapers().contains(paper)) {
            bl2 = true;
            paper = printerAttributes.getDefaultPaper();
        }
        PageOrientation pageOrientation = pageLayout.getPageOrientation();
        if (!printerAttributes.getSupportedPageOrientations().contains((Object)pageOrientation)) {
            bl2 = true;
            pageOrientation = printerAttributes.getDefaultPageOrientation();
        }
        if (bl2) {
            pageLayout = this.fxPrinter.createPageLayout(paper, pageOrientation, Printer$MarginType.DEFAULT);
        }
        return pageLayout;
    }

    private void checkPermissions() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
            String string = this.settings.getOutputFile();
            if (string != null && !string.isEmpty()) {
                securityManager.checkWrite(string);
            }
        }
    }

    @Override
    public boolean print(PageLayout pageLayout, Node node) {
        block6: {
            if (Toolkit.getToolkit().isFxUserThread() && !Toolkit.getToolkit().canStartNestedEventLoop()) {
                throw new IllegalStateException("Printing is not allowed during animation or layout processing");
            }
            if (this.jobError || this.jobDone || this.jobCanceled) {
                return false;
            }
            if (!this.jobRunning) {
                this.checkPermissions();
                this.syncSettingsToAttributes();
                Runnable runnable = new J2DPrinterJob$PrintJobRunnable(this);
                runnable = new Thread(runnable, "Print Job Thread");
                ((Thread)runnable).start();
                this.jobRunning = true;
            }
            try {
                this.j2dPageable.implPrintPage(pageLayout, node);
            }
            catch (Throwable throwable) {
                if (PrismSettings.debug) {
                    System.err.println("printPage caught exception.");
                    throwable.printStackTrace();
                }
                this.jobError = true;
                if (this.jobCanceled) break block6;
                this.jobDone = true;
            }
        }
        return !this.jobError;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean endJob() {
        if (!this.jobRunning || this.jobDone || this.jobCanceled || this.jobError) return this.jobDone && !this.jobError;
        this.jobDone = true;
        try {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notify();
                return this.jobDone;
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (!PrismSettings.debug) return this.jobDone;
            System.err.println("Internal Error " + String.valueOf(illegalStateException));
            return this.jobDone;
        }
    }

    @Override
    public void cancelJob() {
        block7: {
            if (!this.pJob2D.isCancelled()) {
                this.pJob2D.cancel();
            }
            this.jobCanceled = true;
            if (this.jobRunning) {
                this.jobRunning = false;
                try {
                    Object object = this.monitor;
                    synchronized (object) {
                        this.monitor.notify();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    if (!PrismSettings.debug) break block7;
                    System.err.println("Internal Error " + String.valueOf(illegalStateException));
                }
            }
        }
    }

    private static /* synthetic */ void lambda$setEnabledState$2(TKStage tKStage, boolean bl2) {
        tKStage.setEnabled(bl2);
    }

    static {
        AccessController.doPrivileged(() -> {
            String string = "prism_common";
            if (PrismSettings.verbose) {
                System.out.println("Loading Prism common native library ...");
            }
            NativeLibLoader.loadLibrary(string);
            if (PrismSettings.verbose) {
                System.out.println("\tsucceeded.");
            }
            return null;
        });
        onTopClass = null;
    }
}

