/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.paint;

import com.sun.prism.paint.Paint;
import com.sun.prism.paint.Paint$Type;
import java.nio.ByteBuffer;

public final class Color
extends Paint {
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color RED = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    public static final Color GREEN = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private final int argb;
    private final float r;
    private final float g;
    private final float b;
    private final float a;

    public Color(float f2, float f3, float f4, float f5) {
        super(Paint$Type.COLOR, false, false);
        int n2 = (int)(255.0 * (double)f5);
        int n3 = (int)(255.0 * (double)f2 * (double)f5);
        int n4 = (int)(255.0 * (double)f3 * (double)f5);
        int n5 = (int)(255.0 * (double)f4 * (double)f5);
        this.argb = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        this.r = f2;
        this.g = f3;
        this.b = f4;
        this.a = f5;
    }

    public final int getIntArgbPre() {
        return this.argb;
    }

    public final void putRgbaPreBytes(byte[] byArray, int n2) {
        byArray[n2] = (byte)(this.argb >> 16);
        byArray[n2 + 1] = (byte)(this.argb >> 8);
        byArray[n2 + 2] = (byte)this.argb;
        byArray[n2 + 3] = (byte)(this.argb >>> 24);
    }

    public final void putBgraPreBytes(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)this.argb);
        byteBuffer.put((byte)(this.argb >> 8));
        byteBuffer.put((byte)(this.argb >> 16));
        byteBuffer.put((byte)(this.argb >>> 24));
    }

    public final float getRed() {
        return this.r;
    }

    public final float getRedPremult() {
        return this.r * this.a;
    }

    public final float getGreen() {
        return this.g;
    }

    public final float getGreenPremult() {
        return this.g * this.a;
    }

    public final float getBlue() {
        return this.b;
    }

    public final float getBluePremult() {
        return this.b * this.a;
    }

    public final float getAlpha() {
        return this.a;
    }

    @Override
    public final boolean isOpaque() {
        return this.a >= 1.0f;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Color)) {
            return false;
        }
        object = (Color)object;
        return this.r == ((Color)object).r && this.g == ((Color)object).g && this.b == ((Color)object).b && this.a == ((Color)object).a;
    }

    public final int hashCode() {
        int n2 = 159 + Float.floatToIntBits(this.r);
        n2 = n2 * 53 + Float.floatToIntBits(this.g);
        n2 = n2 * 53 + Float.floatToIntBits(this.b);
        n2 = n2 * 53 + Float.floatToIntBits(this.a);
        return n2;
    }

    public final String toString() {
        return "Color[r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "]";
    }
}

