/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.javafx.animation.TickCalculation;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.Settings;
import com.sun.scenario.animation.AbstractPrimaryTimer$MainLoop;
import com.sun.scenario.animation.AnimationPulse;
import com.sun.scenario.animation.shared.PulseReceiver;
import com.sun.scenario.animation.shared.TimerReceiver;
import java.util.Arrays;
import javafx.util.Callback;

public abstract class AbstractPrimaryTimer {
    protected static final String FULLSPEED_PROP = "javafx.animation.fullspeed";
    private static boolean fullspeed = Settings.getBoolean("javafx.animation.fullspeed");
    protected static final String ADAPTIVE_PULSE_PROP = "com.sun.scenario.animation.adaptivepulse";
    private static boolean useAdaptivePulse = Settings.getBoolean("com.sun.scenario.animation.adaptivepulse");
    protected static final String PULSE_PROP = "javafx.animation.pulse";
    protected static final String FRAMERATE_PROP = "javafx.animation.framerate";
    protected static final String FIXED_PULSE_LENGTH_PROP = "com.sun.scenario.animation.fixed.pulse.length";
    protected static final String ANIMATION_MBEAN_ENABLED = "com.sun.scenario.animation.AnimationMBean.enabled";
    protected static final boolean enableAnimationMBean = false;
    private final int PULSE_DURATION_NS = this.getPulseDuration(1000000000);
    private final int PULSE_DURATION_TICKS = this.getPulseDuration((int)TickCalculation.fromMillis(1000.0));
    private static Callback<String, Void> pcl = string -> {
        int n2 = -1;
        switch (string.hashCode()) {
            case -807177548: {
                if (!string.equals(FULLSPEED_PROP)) break;
                n2 = 0;
                break;
            }
            case -1465172662: {
                if (!string.equals(ADAPTIVE_PULSE_PROP)) break;
                n2 = 1;
                break;
            }
            case 868521093: {
                if (!string.equals(ANIMATION_MBEAN_ENABLED)) break;
                n2 = 2;
            }
        }
        switch (n2) {
            case 0: {
                fullspeed = Settings.getBoolean(FULLSPEED_PROP);
                break;
            }
            case 1: {
                useAdaptivePulse = Settings.getBoolean(ADAPTIVE_PULSE_PROP);
                break;
            }
            case 2: {
                AnimationPulse.getDefaultBean().setEnabled(Settings.getBoolean(ANIMATION_MBEAN_ENABLED));
            }
        }
        return null;
    };
    private boolean paused = false;
    private long totalPausedTime;
    private long startPauseTime;
    private PulseReceiver[] receivers = new PulseReceiver[2];
    private int receiversLength;
    private boolean receiversLocked;
    private TimerReceiver[] animationTimers = new TimerReceiver[2];
    private int animationTimersLength;
    private boolean animationTimersLocked;
    private final long fixedPulseLength = Boolean.getBoolean("com.sun.scenario.animation.fixed.pulse.length") ? (long)this.PULSE_DURATION_NS : 0L;
    private long debugNanos = 0L;
    private final AbstractPrimaryTimer$MainLoop theMainLoop = new AbstractPrimaryTimer$MainLoop(this);

    boolean isPaused() {
        return this.paused;
    }

    long getTotalPausedTime() {
        return this.totalPausedTime;
    }

    long getStartPauseTime() {
        return this.startPauseTime;
    }

    public int getDefaultResolution() {
        return this.PULSE_DURATION_TICKS;
    }

    public void pause() {
        if (!this.paused) {
            this.startPauseTime = this.nanos();
            this.paused = true;
        }
    }

    public void resume() {
        if (this.paused) {
            this.paused = false;
            this.totalPausedTime += this.nanos() - this.startPauseTime;
        }
    }

    public long nanos() {
        if (this.fixedPulseLength > 0L) {
            return this.debugNanos;
        }
        if (this.paused) {
            return this.startPauseTime;
        }
        return System.nanoTime() - this.totalPausedTime;
    }

    public boolean isFullspeed() {
        return fullspeed;
    }

    protected AbstractPrimaryTimer() {
    }

    public void addPulseReceiver(PulseReceiver pulseReceiver) {
        boolean bl2;
        boolean bl3 = bl2 = this.receiversLength == this.receivers.length;
        if (this.receiversLocked || bl2) {
            this.receivers = Arrays.copyOf(this.receivers, bl2 ? this.receivers.length * 3 / 2 + 1 : this.receivers.length);
            this.receiversLocked = false;
        }
        this.receivers[this.receiversLength++] = pulseReceiver;
        if (this.receiversLength == 1) {
            this.theMainLoop.updateAnimationRunnable();
        }
    }

    public void removePulseReceiver(PulseReceiver pulseReceiver) {
        if (this.receiversLocked) {
            this.receivers = (PulseReceiver[])this.receivers.clone();
            this.receiversLocked = false;
        }
        for (int i2 = 0; i2 < this.receiversLength; ++i2) {
            if (pulseReceiver != this.receivers[i2]) continue;
            if (i2 == this.receiversLength - 1) {
                this.receivers[i2] = null;
            } else {
                System.arraycopy(this.receivers, i2 + 1, this.receivers, i2, this.receiversLength - i2 - 1);
                this.receivers[this.receiversLength - 1] = null;
            }
            --this.receiversLength;
            break;
        }
        if (this.receiversLength == 0) {
            this.theMainLoop.updateAnimationRunnable();
        }
    }

    public void addAnimationTimer(TimerReceiver timerReceiver) {
        boolean bl2;
        boolean bl3 = bl2 = this.animationTimersLength == this.animationTimers.length;
        if (this.animationTimersLocked || bl2) {
            this.animationTimers = Arrays.copyOf(this.animationTimers, bl2 ? this.animationTimers.length * 3 / 2 + 1 : this.animationTimers.length);
            this.animationTimersLocked = false;
        }
        this.animationTimers[this.animationTimersLength++] = timerReceiver;
        if (this.animationTimersLength == 1) {
            this.theMainLoop.updateAnimationRunnable();
        }
    }

    public void removeAnimationTimer(TimerReceiver timerReceiver) {
        if (this.animationTimersLocked) {
            this.animationTimers = (TimerReceiver[])this.animationTimers.clone();
            this.animationTimersLocked = false;
        }
        for (int i2 = 0; i2 < this.animationTimersLength; ++i2) {
            if (timerReceiver != this.animationTimers[i2]) continue;
            if (i2 == this.animationTimersLength - 1) {
                this.animationTimers[i2] = null;
            } else {
                System.arraycopy(this.animationTimers, i2 + 1, this.animationTimers, i2, this.animationTimersLength - i2 - 1);
                this.animationTimers[this.animationTimersLength - 1] = null;
            }
            --this.animationTimersLength;
            break;
        }
        if (this.animationTimersLength == 0) {
            this.theMainLoop.updateAnimationRunnable();
        }
    }

    protected void recordStart(long l2) {
    }

    protected void recordEnd() {
    }

    protected void recordAnimationEnd() {
    }

    protected abstract void postUpdateAnimationRunnable(DelayedRunnable var1);

    protected abstract int getPulseDuration(int var1);

    protected void timePulseImpl(long l2) {
        if (this.fixedPulseLength > 0L) {
            this.debugNanos += this.fixedPulseLength;
            l2 = this.debugNanos;
        }
        PulseReceiver[] pulseReceiverArray = this.receivers;
        int n2 = this.receiversLength;
        try {
            this.receiversLocked = true;
            for (int i2 = 0; i2 < n2; ++i2) {
                pulseReceiverArray[i2].timePulse(TickCalculation.fromNano(l2));
            }
        }
        finally {
            this.receiversLocked = false;
        }
        this.recordAnimationEnd();
        TimerReceiver[] timerReceiverArray = this.animationTimers;
        int n3 = this.animationTimersLength;
        try {
            this.animationTimersLocked = true;
            for (n2 = 0; n2 < n3; ++n2) {
                timerReceiverArray[n2].handle(l2);
            }
            return;
        }
        finally {
            this.animationTimersLocked = false;
        }
    }

    static {
        Settings.addPropertyChangeListener(pcl);
        int n2 = Settings.getInt(PULSE_PROP, -1);
        if (n2 != -1) {
            System.err.println("Setting PULSE_DURATION to " + n2 + " hz");
        }
    }
}

