/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.GeneralClipInterpolator;
import com.sun.scenario.animation.shared.SimpleClipInterpolator;
import javafx.animation.KeyFrame;
import javafx.util.Duration;

public abstract class ClipInterpolator {
    static ClipInterpolator create(KeyFrame[] keyFrameArray, long[] lArray) {
        if (ClipInterpolator.getRealKeyFrameCount(keyFrameArray) == 2) {
            if (keyFrameArray.length == 1) {
                return new SimpleClipInterpolator(keyFrameArray[0], lArray[0]);
            }
            return new SimpleClipInterpolator(keyFrameArray[0], keyFrameArray[1], lArray[1]);
        }
        return new GeneralClipInterpolator(keyFrameArray, lArray);
    }

    static int getRealKeyFrameCount(KeyFrame[] keyFrameArray) {
        int n2 = keyFrameArray.length;
        if (n2 == 0) {
            return 0;
        }
        if (keyFrameArray[0].getTime().greaterThan(Duration.ZERO)) {
            return n2 + 1;
        }
        return n2;
    }

    abstract ClipInterpolator setKeyFrames(KeyFrame[] var1, long[] var2);

    abstract void interpolate(long var1);

    abstract void validate(boolean var1);
}

