/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.ClipInterpolator;
import com.sun.scenario.animation.shared.InterpolationInterval;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;

class GeneralClipInterpolator
extends ClipInterpolator {
    private KeyFrame[] keyFrames;
    private long[] keyFrameTicks;
    private InterpolationInterval[][] interval = new InterpolationInterval[0][];
    private int[] undefinedStartValues = new int[0];
    private boolean invalid = true;

    GeneralClipInterpolator(KeyFrame[] keyFrameArray, long[] lArray) {
        this.keyFrames = keyFrameArray;
        this.keyFrameTicks = lArray;
    }

    @Override
    ClipInterpolator setKeyFrames(KeyFrame[] keyFrameArray, long[] lArray) {
        if (ClipInterpolator.getRealKeyFrameCount(keyFrameArray) == 2) {
            return ClipInterpolator.create(keyFrameArray, lArray);
        }
        this.keyFrames = keyFrameArray;
        this.keyFrameTicks = lArray;
        this.invalid = true;
        return this;
    }

    @Override
    void validate(boolean n2) {
        if (this.invalid) {
            int n3;
            Object object;
            Object object2;
            int n4;
            HashMap<Object, KeyValue> hashMap = new HashMap<Object, KeyValue>();
            int n5 = this.keyFrames.length;
            for (n4 = 0; n4 < n5; ++n4) {
                object2 = this.keyFrames[n4];
                if (this.keyFrameTicks[n4] != 0L) break;
                for (KeyValue arrayList : ((KeyFrame)object2).getValues()) {
                    hashMap.put(arrayList.getTarget(), arrayList);
                }
            }
            object2 = new HashMap();
            HashSet hashSet = new HashSet();
            while (n4 < n5) {
                KeyFrame keyFrame = this.keyFrames[n4];
                long l2 = this.keyFrameTicks[n4];
                for (KeyValue keyValue : keyFrame.getValues()) {
                    object = keyValue.getTarget();
                    List list = (List)object2.get(object);
                    KeyValue keyValue2 = (KeyValue)hashMap.get(object);
                    if (list == null) {
                        ArrayList<InterpolationInterval> arrayList = new ArrayList<InterpolationInterval>();
                        object2.put(object, arrayList);
                        if (keyValue2 == null) {
                            arrayList.add(InterpolationInterval.create(keyValue, l2));
                            hashSet.add(object);
                        } else {
                            arrayList.add(InterpolationInterval.create(keyValue, l2, keyValue2, l2));
                        }
                    } else {
                        assert (keyValue2 != null);
                        List list2 = list;
                        list.add(InterpolationInterval.create(keyValue, l2, keyValue2, l2 - ((InterpolationInterval)list2.get((int)(list2.size() - 1))).ticks));
                    }
                    hashMap.put(object, keyValue);
                }
                ++n4;
            }
            int n6 = object2.size();
            if (this.interval.length != n6) {
                this.interval = new InterpolationInterval[n6][];
            }
            if (this.undefinedStartValues.length != (n3 = hashSet.size())) {
                this.undefinedStartValues = new int[n3];
            }
            int n7 = 0;
            Iterator<Object> iterator = object2.entrySet().iterator();
            for (int i2 = 0; i2 < n6; ++i2) {
                object = (Map.Entry)iterator.next();
                this.interval[i2] = new InterpolationInterval[((List)object.getValue()).size()];
                ((List)object.getValue()).toArray(this.interval[i2]);
                if (!hashSet.contains(object.getKey())) continue;
                this.undefinedStartValues[n7++] = i2;
            }
            this.invalid = false;
            return;
        }
        if (n2 != 0) {
            for (int n8 : this.undefinedStartValues) {
                this.interval[n8][0].recalculateStartValue();
            }
        }
    }

    @Override
    void interpolate(long l2) {
        block0: for (InterpolationInterval[] interpolationIntervalArray : this.interval) {
            int n2 = interpolationIntervalArray.length;
            long l3 = 0L;
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                InterpolationInterval interpolationInterval = interpolationIntervalArray[i2];
                long l4 = interpolationInterval.ticks;
                if (l2 <= l4) {
                    double d2 = (double)(l2 - l3) / (double)(l4 - l3);
                    interpolationInterval.interpolate(d2);
                    continue block0;
                }
                l3 = l4;
            }
            InterpolationInterval interpolationInterval = interpolationIntervalArray[n2 - 1];
            double d3 = Math.min(1.0, (double)(l2 - l3) / (double)(interpolationInterval.ticks - l3));
            interpolationInterval.interpolate(d3);
        }
    }
}

