/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.AnimationAccessor;
import com.sun.scenario.animation.shared.ClipEnvelope;
import com.sun.scenario.animation.shared.MultiLoopClipEnvelope;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.util.Duration;

public class InfiniteClipEnvelope
extends MultiLoopClipEnvelope {
    protected InfiniteClipEnvelope(Animation animation) {
        super(animation);
        if (animation != null) {
            this.autoReverse = animation.isAutoReverse();
        }
    }

    @Override
    public ClipEnvelope setCycleDuration(Duration duration) {
        if (duration.isIndefinite()) {
            return InfiniteClipEnvelope.create(this.animation);
        }
        this.updateCycleTicks(duration);
        return this;
    }

    @Override
    public ClipEnvelope setCycleCount(int n2) {
        if (n2 != -1) {
            return InfiniteClipEnvelope.create(this.animation);
        }
        return this;
    }

    @Override
    public void setRate(double d2) {
        Animation$Status animation$Status = this.animation.getStatus();
        if (animation$Status != Animation$Status.STOPPED) {
            InfiniteClipEnvelope infiniteClipEnvelope = this;
            infiniteClipEnvelope.setInternalCurrentRate(Math.abs(infiniteClipEnvelope.currentRate - this.rate) < 1.0E-12 ? d2 : -d2);
            this.deltaTicks = this.ticks - this.ticksRateChange(d2);
            if (this.isDirectionChanged(d2)) {
                long l2 = 2L * this.cycleTicks - this.cyclePos;
                this.deltaTicks += l2;
                this.ticks += l2;
            }
            this.abortCurrentPulse();
        }
        this.rate = d2;
    }

    @Override
    protected double calculateCurrentRate() {
        if (!this.autoReverse) {
            return this.rate;
        }
        if (this.isDuringEvenCycle()) {
            return this.rate;
        }
        return -this.rate;
    }

    @Override
    public void timePulse(long l2) {
        if (this.cycleTicks == 0L) {
            return;
        }
        this.aborted = false;
        this.inTimePulse = true;
        try {
            long l3;
            long l4 = this.ticks;
            long l5 = Math.round((double)l2 * Math.abs(this.rate));
            this.ticks = Math.max(0L, this.deltaTicks + l5);
            long l6 = this.ticks - l4;
            if (l6 == 0L) {
                return;
            }
            long l7 = l3 = this.currentRate > 0.0 ? this.cycleTicks - this.cyclePos : this.cyclePos;
            while (l6 >= l3) {
                if (l3 > 0L) {
                    InfiniteClipEnvelope infiniteClipEnvelope;
                    this.cyclePos = infiniteClipEnvelope.currentRate > 0.0 ? this.cycleTicks : 0L;
                    l6 -= l3;
                    AnimationAccessor.getDefault().playTo(this.animation, this.cyclePos, this.cycleTicks);
                    if (this.aborted) {
                        return;
                    }
                }
                if (this.autoReverse) {
                    InfiniteClipEnvelope infiniteClipEnvelope = this;
                    infiniteClipEnvelope.setCurrentRate(-infiniteClipEnvelope.currentRate);
                } else {
                    InfiniteClipEnvelope infiniteClipEnvelope;
                    this.cyclePos = infiniteClipEnvelope.currentRate > 0.0 ? 0L : this.cycleTicks;
                    AnimationAccessor.getDefault().jumpTo(this.animation, this.cyclePos, this.cycleTicks, false);
                }
                l3 = this.cycleTicks;
            }
            if (l6 > 0L) {
                this.cyclePos += this.currentRate > 0.0 ? l6 : -l6;
                AnimationAccessor.getDefault().playTo(this.animation, this.cyclePos, this.cycleTicks);
            }
            return;
        }
        finally {
            this.inTimePulse = false;
        }
    }

    @Override
    public void jumpTo(long l2) {
        if (this.cycleTicks == 0L) {
            return;
        }
        long l3 = this.ticks;
        this.ticks = Math.max(0L, l2) % (2L * this.cycleTicks);
        long l4 = this.ticks - l3;
        if (l4 != 0L) {
            this.deltaTicks += l4;
            if (this.autoReverse) {
                if (this.ticks > this.cycleTicks) {
                    this.cyclePos = 2L * this.cycleTicks - this.ticks;
                    if (this.animation.getStatus() == Animation$Status.RUNNING) {
                        InfiniteClipEnvelope infiniteClipEnvelope = this;
                        infiniteClipEnvelope.setCurrentRate(-infiniteClipEnvelope.rate);
                    }
                } else {
                    this.cyclePos = this.ticks;
                    if (this.animation.getStatus() == Animation$Status.RUNNING) {
                        InfiniteClipEnvelope infiniteClipEnvelope = this;
                        infiniteClipEnvelope.setCurrentRate(infiniteClipEnvelope.rate);
                    }
                }
            } else {
                this.cyclePos = this.ticks % this.cycleTicks;
                if (this.cyclePos == 0L) {
                    this.cyclePos = this.ticks;
                }
            }
            AnimationAccessor.getDefault().jumpTo(this.animation, this.cyclePos, this.cycleTicks, false);
            this.abortCurrentPulse();
        }
    }
}

