/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.javafx.animation.KeyValueHelper;
import com.sun.scenario.animation.NumberTangentInterpolator;
import com.sun.scenario.animation.shared.InterpolationInterval$BooleanInterpolationInterval;
import com.sun.scenario.animation.shared.InterpolationInterval$DoubleInterpolationInterval;
import com.sun.scenario.animation.shared.InterpolationInterval$FloatInterpolationInterval;
import com.sun.scenario.animation.shared.InterpolationInterval$IntegerInterpolationInterval;
import com.sun.scenario.animation.shared.InterpolationInterval$LongInterpolationInterval;
import com.sun.scenario.animation.shared.InterpolationInterval$ObjectInterpolationInterval;
import com.sun.scenario.animation.shared.InterpolationInterval$TangentDoubleInterpolationInterval;
import com.sun.scenario.animation.shared.InterpolationInterval$TangentFloatInterpolationInterval;
import com.sun.scenario.animation.shared.InterpolationInterval$TangentIntegerInterpolationInterval;
import com.sun.scenario.animation.shared.InterpolationInterval$TangentLongInterpolationInterval;
import javafx.animation.Interpolator;
import javafx.animation.KeyValue;

public abstract class InterpolationInterval {
    protected final long ticks;
    protected final Interpolator rightInterpolator;

    protected InterpolationInterval(long l2, Interpolator interpolator) {
        this.ticks = l2;
        this.rightInterpolator = interpolator;
    }

    public abstract void interpolate(double var1);

    public abstract void recalculateStartValue();

    public static InterpolationInterval create(KeyValue keyValue, long l2, KeyValue keyValue2, long l3) {
        switch (KeyValueHelper.getType(keyValue)) {
            case BOOLEAN: {
                return new InterpolationInterval$BooleanInterpolationInterval(keyValue, l2, keyValue2.getEndValue());
            }
            case DOUBLE: {
                if (keyValue2.getInterpolator() instanceof NumberTangentInterpolator || keyValue.getInterpolator() instanceof NumberTangentInterpolator) {
                    return new InterpolationInterval$TangentDoubleInterpolationInterval(keyValue, l2, keyValue2, l3);
                }
                return new InterpolationInterval$DoubleInterpolationInterval(keyValue, l2, keyValue2.getEndValue());
            }
            case FLOAT: {
                if (keyValue2.getInterpolator() instanceof NumberTangentInterpolator || keyValue.getInterpolator() instanceof NumberTangentInterpolator) {
                    return new InterpolationInterval$TangentFloatInterpolationInterval(keyValue, l2, keyValue2, l3);
                }
                return new InterpolationInterval$FloatInterpolationInterval(keyValue, l2, keyValue2.getEndValue());
            }
            case INTEGER: {
                if (keyValue2.getInterpolator() instanceof NumberTangentInterpolator || keyValue.getInterpolator() instanceof NumberTangentInterpolator) {
                    return new InterpolationInterval$TangentIntegerInterpolationInterval(keyValue, l2, keyValue2, l3);
                }
                return new InterpolationInterval$IntegerInterpolationInterval(keyValue, l2, keyValue2.getEndValue());
            }
            case LONG: {
                if (keyValue2.getInterpolator() instanceof NumberTangentInterpolator || keyValue.getInterpolator() instanceof NumberTangentInterpolator) {
                    return new InterpolationInterval$TangentLongInterpolationInterval(keyValue, l2, keyValue2, l3);
                }
                return new InterpolationInterval$LongInterpolationInterval(keyValue, l2, keyValue2.getEndValue());
            }
            case OBJECT: {
                return new InterpolationInterval$ObjectInterpolationInterval(keyValue, l2, keyValue2.getEndValue());
            }
        }
        throw new RuntimeException("Should not reach here");
    }

    public static InterpolationInterval create(KeyValue keyValue, long l2) {
        switch (KeyValueHelper.getType(keyValue)) {
            case BOOLEAN: {
                return new InterpolationInterval$BooleanInterpolationInterval(keyValue, l2);
            }
            case DOUBLE: {
                if (keyValue.getInterpolator() instanceof NumberTangentInterpolator) {
                    return new InterpolationInterval$TangentDoubleInterpolationInterval(keyValue, l2);
                }
                return new InterpolationInterval$DoubleInterpolationInterval(keyValue, l2);
            }
            case FLOAT: {
                if (keyValue.getInterpolator() instanceof NumberTangentInterpolator) {
                    return new InterpolationInterval$TangentFloatInterpolationInterval(keyValue, l2);
                }
                return new InterpolationInterval$FloatInterpolationInterval(keyValue, l2);
            }
            case INTEGER: {
                if (keyValue.getInterpolator() instanceof NumberTangentInterpolator) {
                    return new InterpolationInterval$TangentIntegerInterpolationInterval(keyValue, l2);
                }
                return new InterpolationInterval$IntegerInterpolationInterval(keyValue, l2);
            }
            case LONG: {
                if (keyValue.getInterpolator() instanceof NumberTangentInterpolator) {
                    return new InterpolationInterval$TangentLongInterpolationInterval(keyValue, l2);
                }
                return new InterpolationInterval$LongInterpolationInterval(keyValue, l2);
            }
            case OBJECT: {
                return new InterpolationInterval$ObjectInterpolationInterval(keyValue, l2);
            }
        }
        throw new RuntimeException("Should not reach here");
    }
}

