/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.FloatMap$Entry;
import com.sun.scenario.effect.LockableResource;
import com.sun.scenario.effect.impl.Renderer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;

public class FloatMap {
    private final int width;
    private final int height;
    private final FloatBuffer buf;
    private boolean cacheValid;
    private Map<FilterContext, FloatMap$Entry> cache;

    public FloatMap(int n2, int n3) {
        if (n2 <= 0 || n2 > 4096 || n3 <= 0 || n3 > 4096) {
            throw new IllegalArgumentException("Width and height must be in the range [1, 4096]");
        }
        this.width = n2;
        this.height = n3;
        n2 = n2 * n3 << 2;
        this.buf = FloatBuffer.wrap(new float[n2]);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float[] getData() {
        return this.buf.array();
    }

    public FloatBuffer getBuffer() {
        return this.buf;
    }

    public float getSample(int n2, int n3, int n4) {
        return this.buf.get((n2 + n3 * this.width << 2) + n4);
    }

    public void setSample(int n2, int n3, int n4, float f2) {
        this.buf.put((n2 + n3 * this.width << 2) + n4, f2);
        this.cacheValid = false;
    }

    public void setSamples(int n2, int n3, float f2) {
        n2 = n2 + n3 * this.width << 2;
        this.buf.put(n2, f2);
        this.cacheValid = false;
    }

    public void setSamples(int n2, int n3, float f2, float f3) {
        n2 = n2 + n3 * this.width << 2;
        this.buf.put(n2, f2);
        this.buf.put(n2 + 1, f3);
        this.cacheValid = false;
    }

    public void setSamples(int n2, int n3, float f2, float f3, float f4) {
        n2 = n2 + n3 * this.width << 2;
        this.buf.put(n2, f2);
        this.buf.put(n2 + 1, f3);
        this.buf.put(n2 + 2, f4);
        this.cacheValid = false;
    }

    public void setSamples(int n2, int n3, float f2, float f3, float f4, float f5) {
        n2 = n2 + n3 * this.width << 2;
        this.buf.put(n2, f2);
        this.buf.put(n2 + 1, f3);
        this.buf.put(n2 + 2, f4);
        this.buf.put(n2 + 3, f5);
        this.cacheValid = false;
    }

    public void put(float[] fArray) {
        this.buf.rewind();
        this.buf.put(fArray);
        this.buf.rewind();
        this.cacheValid = false;
    }

    /*
     * WARNING - void declaration
     */
    public LockableResource getAccelData(FilterContext filterContext) {
        void var3_9;
        void var3_6;
        if (this.cache == null) {
            this.cache = new HashMap<FilterContext, FloatMap$Entry>();
        } else if (!this.cacheValid) {
            for (FloatMap$Entry object2 : this.cache.values()) {
                ((FloatMap$Entry)renderer.next()).valid = false;
            }
            this.cacheValid = true;
        }
        Renderer renderer = Renderer.getRenderer(filterContext);
        FloatMap$Entry floatMap$Entry = this.cache.get(filterContext);
        if (floatMap$Entry != null) {
            floatMap$Entry.texture.lock();
            if (floatMap$Entry.texture.isLost()) {
                floatMap$Entry.texture.unlock();
                this.cache.remove(filterContext);
                Object var3_5 = null;
            }
        }
        if (var3_6 == null) {
            LockableResource lockableResource = renderer.createFloatTexture(this.width, this.height);
            FloatMap$Entry floatMap$Entry2 = new FloatMap$Entry(lockableResource);
            this.cache.put(filterContext, floatMap$Entry2);
        }
        if (!var3_9.valid) {
            renderer.updateFloatTexture(var3_9.texture, this);
            var3_9.valid = true;
        }
        return var3_9.texture;
    }
}

