/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl;

import com.sun.javafx.PlatformUtil;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.impl.Renderer;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.AccessController;

class RendererFactory {
    private static String rootPkg = "com.sun.scenario.effect";
    private static boolean tryRSL = true;
    private static boolean trySIMD = false;
    private static boolean tryJOGL = PlatformUtil.isMac();
    private static boolean tryPrism = true;

    RendererFactory() {
    }

    private static boolean isRSLFriendly(Class classArray) {
        if (classArray.getName().equals("sun.java2d.pipe.hw.AccelGraphicsConfig")) {
            return true;
        }
        boolean bl2 = false;
        for (Class<?> clazz : classArray.getInterfaces()) {
            if (!RendererFactory.isRSLFriendly(clazz)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    private static boolean isRSLAvailable(FilterContext filterContext) {
        return RendererFactory.isRSLFriendly(filterContext.getReferent().getClass());
    }

    private static Renderer createRSLRenderer(FilterContext filterContext) {
        try {
            GenericDeclaration genericDeclaration = Class.forName(rootPkg + ".impl.j2d.rsl.RSLRenderer");
            genericDeclaration = genericDeclaration.getMethod("createRenderer", FilterContext.class);
            return (Renderer)((Method)genericDeclaration).invoke(null, filterContext);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Renderer createJOGLRenderer(FilterContext filterContext) {
        if (tryJOGL) {
            try {
                GenericDeclaration genericDeclaration = Class.forName(rootPkg + ".impl.j2d.jogl.JOGLRenderer");
                genericDeclaration = genericDeclaration.getMethod("createRenderer", FilterContext.class);
                return (Renderer)((Method)genericDeclaration).invoke(null, filterContext);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private static Renderer createPrismRenderer(FilterContext filterContext) {
        if (tryPrism) {
            try {
                GenericDeclaration genericDeclaration = Class.forName(rootPkg + ".impl.prism.PrRenderer");
                genericDeclaration = genericDeclaration.getMethod("createRenderer", FilterContext.class);
                return (Renderer)((Method)genericDeclaration).invoke(null, filterContext);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private static Renderer getSSERenderer() {
        if (trySIMD) {
            try {
                Object object = Class.forName(rootPkg + ".impl.j2d.J2DSWRenderer");
                object = ((Class)object).getMethod("getSSEInstance", null);
                object = (Renderer)((Method)object).invoke(null, null);
                if (object != null) {
                    return object;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
            }
            trySIMD = false;
        }
        return null;
    }

    private static Renderer getJavaRenderer() {
        try {
            Object object = Class.forName(rootPkg + ".impl.prism.sw.PSWRenderer");
            Class<?> clazz = Class.forName("com.sun.glass.ui.Screen");
            object = ((Class)object).getMethod("createJSWInstance", clazz);
            object = (Renderer)((Method)object).invoke(null, new Object[]{null});
            if (object != null) {
                return object;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
        }
        return null;
    }

    private static Renderer getJavaRenderer(FilterContext object) {
        try {
            GenericDeclaration genericDeclaration = Class.forName(rootPkg + ".impl.prism.sw.PSWRenderer");
            genericDeclaration = genericDeclaration.getMethod("createJSWInstance", FilterContext.class);
            object = (Renderer)((Method)genericDeclaration).invoke(null, object);
            if (object != null) {
                return object;
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    static Renderer getSoftwareRenderer() {
        Renderer renderer = RendererFactory.getSSERenderer();
        if (renderer == null) {
            renderer = RendererFactory.getJavaRenderer();
        }
        return renderer;
    }

    static Renderer createRenderer(FilterContext filterContext) {
        return AccessController.doPrivileged(() -> {
            Renderer renderer = null;
            String string = filterContext.getClass().getName();
            if ((string = string.substring(string.lastIndexOf(".") + 1)).equals("PrFilterContext") && tryPrism) {
                renderer = RendererFactory.createPrismRenderer(filterContext);
            }
            if (renderer == null && tryRSL && RendererFactory.isRSLAvailable(filterContext)) {
                renderer = RendererFactory.createRSLRenderer(filterContext);
            }
            if (renderer == null && tryJOGL) {
                renderer = RendererFactory.createJOGLRenderer(filterContext);
            }
            if (renderer == null && trySIMD) {
                renderer = RendererFactory.getSSERenderer();
            }
            if (renderer == null) {
                renderer = RendererFactory.getJavaRenderer(filterContext);
            }
            return renderer;
        });
    }

    static {
        try {
            String string;
            if ("false".equals(System.getProperty("decora.rsl"))) {
                tryRSL = false;
            }
            if ("false".equals(System.getProperty("decora.simd"))) {
                trySIMD = false;
            }
            if ((string = System.getProperty("decora.jogl")) != null) {
                tryJOGL = Boolean.parseBoolean(string);
            }
            if ("false".equals(System.getProperty("decora.prism"))) {
                tryPrism = false;
            }
        }
        catch (SecurityException securityException) {}
    }
}

