/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw.sse;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.PhongLighting;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.RenderState;
import com.sun.scenario.effect.impl.sw.sse.SSEEffectPeer;
import com.sun.scenario.effect.light.PointLight;
import com.sun.scenario.effect.light.SpotLight;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class SSEPhongLighting_POINTPeer
extends SSEEffectPeer {
    private FloatBuffer kvals;

    public SSEPhongLighting_POINTPeer(FilterContext filterContext, Renderer renderer, String string) {
        super(filterContext, renderer, string);
    }

    @Override
    protected final PhongLighting getEffect() {
        return (PhongLighting)super.getEffect();
    }

    private float getSurfaceScale() {
        return this.getEffect().getSurfaceScale();
    }

    private float getDiffuseConstant() {
        return this.getEffect().getDiffuseConstant();
    }

    private float getSpecularConstant() {
        return this.getEffect().getSpecularConstant();
    }

    private float getSpecularExponent() {
        return this.getEffect().getSpecularExponent();
    }

    private float[] getNormalizedLightPosition() {
        return this.getEffect().getLight().getNormalizedLightPosition();
    }

    private float[] getLightPosition() {
        PointLight pointLight = (PointLight)this.getEffect().getLight();
        return new float[]{pointLight.getX(), pointLight.getY(), pointLight.getZ()};
    }

    private float[] getLightColor() {
        return this.getEffect().getLight().getColor().getPremultipliedRGBComponents();
    }

    private float getLightSpecularExponent() {
        return ((SpotLight)this.getEffect().getLight()).getSpecularExponent();
    }

    private float[] getNormalizedLightDirection() {
        return ((SpotLight)this.getEffect().getLight()).getNormalizedLightDirection();
    }

    private FloatBuffer getKvals() {
        Rectangle rectangle = this.getInputNativeBounds(0);
        float f2 = 1.0f / (float)rectangle.width;
        float f3 = 1.0f / (float)rectangle.height;
        float[] fArray = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
        float[] fArray2 = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
        if (this.kvals == null) {
            this.kvals = BufferUtil.newFloatBuffer(32);
        }
        this.kvals.clear();
        int n2 = 0;
        float f4 = -this.getSurfaceScale() * 0.25f;
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int i3 = -1; i3 <= 1; ++i3) {
                if (i2 != 0 || i3 != 0) {
                    this.kvals.put((float)i3 * f2);
                    this.kvals.put((float)i2 * f3);
                    this.kvals.put(fArray[n2] * f4);
                    this.kvals.put(fArray2[n2] * f4);
                }
                ++n2;
            }
        }
        this.kvals.rewind();
        return this.kvals;
    }

    private int getKvalsArrayLength() {
        return 8;
    }

    @Override
    public ImageData filter(Effect object, RenderState object2, BaseTransform baseTransform, Rectangle rectangle, ImageData ... imageDataArray) {
        this.setEffect((Effect)object);
        object = this.getResultBounds(baseTransform, rectangle, imageDataArray);
        this.setDestBounds((Rectangle)object);
        object2 = (HeapImage)imageDataArray[0].getTransformedImage((Rectangle)object);
        int n2 = object2.getPhysicalWidth();
        int n3 = object2.getPhysicalHeight();
        int n4 = object2.getScanlineStride();
        int[] nArray = object2.getPixelArray();
        Object object3 = new Rectangle(0, 0, n2, n3);
        Object object4 = imageDataArray[0].getTransformedBounds((Rectangle)object);
        BaseTransform baseTransform2 = BaseTransform.IDENTITY_TRANSFORM;
        this.setInputBounds(0, (Rectangle)object4);
        this.setInputNativeBounds(0, (Rectangle)object3);
        object3 = (HeapImage)imageDataArray[1].getTransformedImage((Rectangle)object);
        int n5 = object3.getPhysicalWidth();
        int n6 = object3.getPhysicalHeight();
        int n7 = object3.getScanlineStride();
        int[] nArray2 = object3.getPixelArray();
        Object object5 = new Rectangle(0, 0, n5, n6);
        Rectangle rectangle2 = imageDataArray[1].getTransformedBounds((Rectangle)object);
        Object object6 = BaseTransform.IDENTITY_TRANSFORM;
        this.setInputBounds(1, rectangle2);
        this.setInputNativeBounds(1, (Rectangle)object5);
        object5 = new float[4];
        this.getTextureCoordinates(0, (float[])object5, ((Rectangle)object4).x, ((Rectangle)object4).y, n2, n3, (Rectangle)object, baseTransform2);
        object4 = new float[4];
        this.getTextureCoordinates(1, (float[])object4, rectangle2.x, rectangle2.y, n5, n6, (Rectangle)object, (BaseTransform)object6);
        int n8 = ((Rectangle)object).width;
        int n9 = ((Rectangle)object).height;
        object6 = (HeapImage)((Object)this.getRenderer().getCompatibleImage(n8, n9));
        this.setDestNativeBounds(object6.getPhysicalWidth(), object6.getPhysicalHeight());
        int n10 = object6.getScanlineStride();
        int[] nArray3 = object6.getPixelArray();
        float f2 = this.getDiffuseConstant();
        Object object7 = this.getKvals();
        float[] fArray = new float[((Buffer)object7).capacity()];
        ((FloatBuffer)object7).get(fArray);
        object7 = this.getLightColor();
        float[] fArray2 = this.getLightPosition();
        float f3 = this.getSpecularConstant();
        float f4 = this.getSpecularExponent();
        float f5 = this.getSurfaceScale();
        SSEPhongLighting_POINTPeer.filter(nArray3, 0, 0, n8, n9, n10, nArray, (float)object5[0], (float)object5[1], (float)object5[2], (float)object5[3], n2, n3, n4, f2, fArray, (float)object7[0], (float)object7[1], (float)object7[2], fArray2[0], fArray2[1], fArray2[2], nArray2, (float)object4[0], (float)object4[1], (float)object4[2], (float)object4[3], n5, n6, n7, f3, f4, f5);
        imageDataArray[0].releaseTransformedImage((Filterable)object2);
        imageDataArray[1].releaseTransformedImage((Filterable)object3);
        return new ImageData(this.getFilterContext(), (Filterable)object6, (Rectangle)object);
    }

    private static native void filter(int[] var0, int var1, int var2, int var3, int var4, int var5, int[] var6, float var7, float var8, float var9, float var10, int var11, int var12, int var13, float var14, float[] var15, float var16, float var17, float var18, float var19, float var20, float var21, int[] var22, float var23, float var24, float var25, float var26, int var27, int var28, int var29, float var30, float var31, float var32);
}

