/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.impl.DefaultTokenizedJwe;
import io.jsonwebtoken.impl.DefaultTokenizedJwt;
import io.jsonwebtoken.impl.TokenizedJwt;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import java.io.IOException;
import java.io.Reader;

public class JwtTokenizer {
    static final char DELIMITER = '.';
    private static final String DELIM_ERR_MSG_PREFIX = "Invalid compact JWT string: Compact JWSs must contain exactly 2 period characters, and compact JWEs must contain exactly 4.  Found: ";

    private static int read(Reader reader, char[] object) {
        try {
            return reader.read((char[])object);
        }
        catch (IOException iOException) {
            object = "Unable to read compact JWT: " + iOException.getMessage();
            throw new MalformedJwtException((String)object, iOException);
        }
    }

    public <T extends TokenizedJwt> T tokenize(Reader reader) {
        Assert.notNull(reader, "Reader argument cannot be null.");
        CharSequence charSequence = "";
        CharSequence charSequence2 = "";
        CharSequence charSequence3 = "";
        CharSequence charSequence4 = "";
        String string = "";
        int n2 = 0;
        char[] cArray = new char[4096];
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(4096);
        while (n3 != -1) {
            n3 = JwtTokenizer.read(reader, cArray);
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = cArray[i2];
                if (Character.isWhitespace(c2)) {
                    String string2 = "Compact JWT strings may not contain whitespace.";
                    throw new MalformedJwtException(string2);
                }
                if (c2 == '.') {
                    CharSequence charSequence5 = Strings.clean(stringBuilder);
                    charSequence5 = charSequence5 != null ? charSequence5.toString() : "";
                    switch (n2) {
                        case 0: {
                            charSequence = charSequence5;
                            break;
                        }
                        case 1: {
                            charSequence2 = charSequence5;
                            charSequence3 = charSequence5;
                            break;
                        }
                        case 2: {
                            charSequence2 = "";
                            charSequence4 = charSequence5;
                            break;
                        }
                        case 3: {
                            charSequence2 = charSequence5;
                        }
                    }
                    ++n2;
                    stringBuilder.setLength(0);
                    continue;
                }
                stringBuilder.append(c2);
            }
        }
        if (n2 != 2 && n2 != 4) {
            String string3 = DELIM_ERR_MSG_PREFIX + n2;
            throw new MalformedJwtException(string3);
        }
        if (stringBuilder.length() > 0) {
            string = stringBuilder.toString();
        }
        if (n2 == 2) {
            return (T)new DefaultTokenizedJwt(charSequence, charSequence2, string);
        }
        return (T)new DefaultTokenizedJwe(charSequence, charSequence2, string, charSequence3, charSequence4);
    }
}

