/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.impl.ParameterMap$EntrySet;
import io.jsonwebtoken.impl.ParameterMap$KeySet;
import io.jsonwebtoken.impl.ParameterMap$ValueSet;
import io.jsonwebtoken.impl.lang.Nameable;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.impl.lang.Parameters;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.lang.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ParameterMap
implements Nameable,
ParameterReadable,
Map<String, Object> {
    protected final Registry<String, ? extends Parameter<?>> PARAMS;
    protected final Map<String, Object> values;
    protected final Map<String, Object> idiomaticValues;
    private final boolean initialized;
    private final boolean mutable;

    public ParameterMap(Set<Parameter<?>> set) {
        this(Parameters.registry(set));
    }

    public ParameterMap(Registry<String, ? extends Parameter<?>> registry) {
        this(registry, null, true);
    }

    public ParameterMap(Registry<String, ? extends Parameter<?>> registry, Map<String, ?> map) {
        this(registry, Assert.notNull(map, "Map argument cannot be null."), false);
    }

    public ParameterMap(Registry<String, ? extends Parameter<?>> registry, Map<String, ?> map, boolean bl2) {
        Assert.notNull(registry, "Parameter registry cannot be null.");
        Assert.notEmpty(registry.values(), "Parameter registry cannot be empty.");
        this.PARAMS = registry;
        this.values = new LinkedHashMap<String, Object>();
        this.idiomaticValues = new LinkedHashMap<String, Object>();
        if (!Collections.isEmpty(map)) {
            this.putAll((Map<? extends String, ?>)map);
        }
        this.mutable = bl2;
        this.initialized = true;
    }

    private void assertMutable() {
        if (this.initialized && !this.mutable) {
            String string = this.getName() + " instance is immutable and may not be modified.";
            throw new UnsupportedOperationException(string);
        }
    }

    protected ParameterMap replace(Parameter<?> object) {
        object = Parameters.replace(this.PARAMS, object);
        ParameterMap parameterMap = this;
        return new ParameterMap((Registry<String, ? extends Parameter<?>>)object, parameterMap, parameterMap.mutable);
    }

    @Override
    public String getName() {
        return "Map";
    }

    @Override
    public <T> T get(Parameter<T> parameter) {
        Assert.notNull(parameter, "Parameter cannot be null.");
        Object object = Assert.hasText(parameter.getId(), "Parameter id cannot be null or empty.");
        object = this.idiomaticValues.get(object);
        return parameter.cast(object);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.values.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.values.containsValue(object);
    }

    @Override
    public Object get(Object object) {
        return this.values.get(object);
    }

    @Override
    protected final <T> Object put(Parameter<T> parameter, Object object) {
        this.assertMutable();
        Assert.notNull(parameter, "Parameter cannot be null.");
        Assert.hasText(parameter.getId(), "Parameter id cannot be null or empty.");
        return this.apply(parameter, object);
    }

    @Override
    public final Object put(String string, Object object) {
        this.assertMutable();
        string = Assert.notNull(Strings.clean(string), "Member name cannot be null or empty.");
        Parameter parameter = (Parameter)this.PARAMS.get(string);
        if (parameter != null) {
            return this.put(parameter, object);
        }
        return this.nullSafePut(string, object);
    }

    private Object nullSafePut(String string, Object object) {
        if (object == null) {
            return this.remove(string);
        }
        this.idiomaticValues.put(string, object);
        return this.values.put(string, object);
    }

    private <T> Object apply(Parameter<T> object, Object object2) {
        Object b2;
        Object a2;
        String string = object.getId();
        if (Objects.isEmpty(object2)) {
            return this.remove(string);
        }
        try {
            a2 = object.applyFrom(object2);
            Assert.notNull(a2, "Parameter's resulting idiomaticValue cannot be null.");
            b2 = object.applyTo(a2);
            Assert.notNull(b2, "Parameter's resulting canonicalValue cannot be null.");
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("Invalid ").append(this.getName()).append(" ").append(object).append(" value");
            if (object.isSecret()) {
                stringBuilder.append(": <redacted>");
            } else if (!(object2 instanceof byte[])) {
                stringBuilder.append(": ").append(Objects.nullSafeToString(object2));
            }
            stringBuilder.append(". ").append(exception.getMessage());
            object = stringBuilder.toString();
            throw new IllegalArgumentException((String)object, exception);
        }
        this.idiomaticValues.put(string, a2);
        return this.values.put(string, b2);
    }

    @Override
    public Object remove(Object object) {
        this.assertMutable();
        this.idiomaticValues.remove(object);
        return this.values.remove(object);
    }

    @Override
    public void putAll(Map<? extends String, ?> object) {
        if (object == null) {
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            this.put(string, entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.assertMutable();
        this.values.clear();
        this.idiomaticValues.clear();
    }

    @Override
    public Set<String> keySet() {
        return new ParameterMap$KeySet(this, null);
    }

    @Override
    public Collection<Object> values() {
        return new ParameterMap$ValueSet(this, null);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new ParameterMap$EntrySet(this, null);
    }

    public String toString() {
        return this.values.toString();
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this.values.equals(object);
    }
}

