/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.CompressionCodec;
import io.jsonwebtoken.Jwts$ZIP;
import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.io.CompressionAlgorithm;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Strings;
import java.io.InputStream;
import java.io.OutputStream;

class Payload {
    static final Payload EMPTY = new Payload(Bytes.EMPTY, null);
    private final CharSequence string;
    private final byte[] bytes;
    private final Claims claims;
    private final InputStream inputStream;
    private final boolean inputStreamEmpty;
    private final String contentType;
    private CompressionAlgorithm zip;
    private boolean claimsExpected;

    Payload(Claims claims) {
        this(claims, null, null, null, null);
    }

    Payload(CharSequence charSequence, String string) {
        this(null, charSequence, null, null, string);
    }

    Payload(byte[] byArray, String string) {
        this(null, null, byArray, null, string);
    }

    Payload(InputStream inputStream, String string) {
        this(null, null, null, inputStream, string);
    }

    private Payload(Claims object, CharSequence object2, byte[] byArray, InputStream inputStream, String string) {
        this.claims = object;
        this.string = Strings.clean((CharSequence)object2);
        this.contentType = Strings.clean(string);
        object = inputStream;
        object2 = Bytes.nullSafe(byArray);
        if (Strings.hasText(this.string)) {
            object2 = Strings.utf8(this.string);
        }
        this.bytes = (byte[])object2;
        if (object == null && !Bytes.isEmpty(this.bytes)) {
            object = Streams.of((byte[])object2);
        }
        this.inputStreamEmpty = object == null;
        this.inputStream = this.inputStreamEmpty ? Streams.of(Bytes.EMPTY) : object;
    }

    boolean isClaims() {
        return !Collections.isEmpty(this.claims);
    }

    Claims getRequiredClaims() {
        return Assert.notEmpty(this.claims, "Claims cannot be null or empty when calling this method.");
    }

    boolean isString() {
        return Strings.hasText(this.string);
    }

    String getContentType() {
        return this.contentType;
    }

    public void setZip(CompressionAlgorithm compressionAlgorithm) {
        this.zip = compressionAlgorithm;
    }

    boolean isCompressed() {
        return this.zip != null;
    }

    public void setClaimsExpected(boolean bl2) {
        this.claimsExpected = bl2;
    }

    boolean isConsumable() {
        return !this.isClaims() && (this.isString() || !Bytes.isEmpty(this.bytes) || this.inputStream != null && this.claimsExpected);
    }

    boolean isEmpty() {
        return !this.isClaims() && !this.isString() && Bytes.isEmpty(this.bytes) && this.inputStreamEmpty;
    }

    public OutputStream compress(OutputStream outputStream) {
        if (this.zip != null) {
            return this.zip.compress(outputStream);
        }
        return outputStream;
    }

    public Payload decompress(CompressionAlgorithm compressionAlgorithm) {
        Assert.notNull(compressionAlgorithm, "CompressionAlgorithm cannot be null.");
        Object object = this;
        if (!this.isString() && this.isConsumable()) {
            if (compressionAlgorithm.equals(Jwts$ZIP.DEF) && !Bytes.isEmpty(this.bytes)) {
                object = ((CompressionCodec)compressionAlgorithm).decompress(this.bytes);
                object = new Payload(this.claims, this.string, (byte[])object, null, this.getContentType());
            } else {
                object = this.toInputStream();
                object = compressionAlgorithm.decompress((InputStream)object);
                object = new Payload(this.claims, this.string, this.bytes, (InputStream)object, this.getContentType());
            }
            ((Payload)object).setClaimsExpected(this.claimsExpected);
        }
        return object;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    InputStream toInputStream() {
        Assert.state(!this.isClaims(), "Claims exist, cannot convert to InputStream directly.");
        return this.inputStream;
    }
}

