/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import io.jsonwebtoken.impl.io.BaseNCodec$Context;
import io.jsonwebtoken.impl.io.CodecPolicy;
import io.jsonwebtoken.lang.Strings;
import java.util.Arrays;
import java.util.Objects;

abstract class BaseNCodec {
    static final int EOF = -1;
    public static final int MIME_CHUNK_SIZE = 76;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    protected static final CodecPolicy DECODING_POLICY_DEFAULT = CodecPolicy.LENIENT;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    protected final byte pad;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;
    private final CodecPolicy decodingPolicy;

    private static int createPositiveCapacity(int n2) {
        if (n2 < 0) {
            throw new OutOfMemoryError("Unable to allocate array size: " + ((long)n2 & 0xFFFFFFFFL));
        }
        return Math.max(n2, 0x7FFFFFF7);
    }

    @Deprecated
    protected static boolean isWhiteSpace(byte by2) {
        return Character.isWhitespace(by2);
    }

    private static int compareUnsigned(int n2, int n3) {
        return Integer.compare(n2 + Integer.MIN_VALUE, n3 + Integer.MIN_VALUE);
    }

    private static byte[] resizeBuffer(BaseNCodec$Context baseNCodec$Context, int n2) {
        int n3 = baseNCodec$Context.buffer.length;
        if (BaseNCodec.compareUnsigned(n3 <<= 1, n2) < 0) {
            n3 = n2;
        }
        if (BaseNCodec.compareUnsigned(n3, 0x7FFFFFF7) > 0) {
            n3 = BaseNCodec.createPositiveCapacity(n2);
        }
        byte[] byArray = Arrays.copyOf(baseNCodec$Context.buffer, n3);
        baseNCodec$Context.buffer = byArray;
        return byArray;
    }

    protected BaseNCodec(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, 61);
    }

    protected BaseNCodec(int n2, int n3, int n4, int n5, byte by2) {
        this(n2, n3, n4, n5, by2, DECODING_POLICY_DEFAULT);
    }

    protected BaseNCodec(int n2, int n3, int n4, int n5, byte by2, CodecPolicy codecPolicy) {
        this.unencodedBlockSize = n2;
        this.encodedBlockSize = n3;
        n2 = n4 > 0 && n5 > 0 ? 1 : 0;
        this.lineLength = n2 != 0 ? n4 / n3 * n3 : 0;
        this.chunkSeparatorLength = n5;
        this.pad = by2;
        this.decodingPolicy = Objects.requireNonNull(codecPolicy, "codecPolicy");
    }

    int available(BaseNCodec$Context baseNCodec$Context) {
        if (this.hasData(baseNCodec$Context)) {
            return baseNCodec$Context.pos - baseNCodec$Context.readPos;
        }
        return 0;
    }

    protected boolean containsAlphabetOrPad(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        for (byte by2 : byArray) {
            if (this.pad != by2 && !this.isInAlphabet(by2)) continue;
            return true;
        }
        return false;
    }

    static int length(byte[] byArray) {
        if (byArray != null) {
            return byArray.length;
        }
        return 0;
    }

    static boolean isEmpty(byte[] byArray) {
        return BaseNCodec.length(byArray) == 0;
    }

    public byte[] decode(byte[] byArray) {
        if (BaseNCodec.isEmpty(byArray)) {
            return byArray;
        }
        BaseNCodec$Context baseNCodec$Context = new BaseNCodec$Context();
        this.decode(byArray, 0, byArray.length, baseNCodec$Context);
        this.decode(byArray, 0, -1, baseNCodec$Context);
        byArray = new byte[baseNCodec$Context.pos];
        this.readResults(byArray, 0, byArray.length, baseNCodec$Context);
        return byArray;
    }

    abstract void decode(byte[] var1, int var2, int var3, BaseNCodec$Context var4);

    public byte[] decode(String string) {
        return this.decode(Strings.utf8(string));
    }

    public byte[] encode(byte[] byArray) {
        if (BaseNCodec.isEmpty(byArray)) {
            return byArray;
        }
        return this.encode(byArray, 0, byArray.length);
    }

    public byte[] encode(byte[] byArray, int n2, int n3) {
        if (BaseNCodec.isEmpty(byArray)) {
            return byArray;
        }
        BaseNCodec$Context baseNCodec$Context = new BaseNCodec$Context();
        this.encode(byArray, n2, n3, baseNCodec$Context);
        this.encode(byArray, n2, -1, baseNCodec$Context);
        byArray = new byte[baseNCodec$Context.pos - baseNCodec$Context.readPos];
        this.readResults(byArray, 0, byArray.length, baseNCodec$Context);
        return byArray;
    }

    abstract void encode(byte[] var1, int var2, int var3, BaseNCodec$Context var4);

    public String encodeAsString(byte[] byArray) {
        return Strings.utf8(this.encode(byArray));
    }

    public String encodeToString(byte[] byArray) {
        return Strings.utf8(this.encode(byArray));
    }

    protected byte[] ensureBufferSize(int n2, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.buffer == null) {
            baseNCodec$Context.buffer = new byte[Math.max(n2, this.getDefaultBufferSize())];
            baseNCodec$Context.pos = 0;
            baseNCodec$Context.readPos = 0;
        } else if (baseNCodec$Context.pos + n2 - baseNCodec$Context.buffer.length > 0) {
            BaseNCodec$Context baseNCodec$Context2 = baseNCodec$Context;
            return BaseNCodec.resizeBuffer(baseNCodec$Context2, baseNCodec$Context2.pos + n2);
        }
        return baseNCodec$Context.buffer;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    public long getEncodedLength(byte[] byArray) {
        long l2 = (long)((byArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            long l3 = l2;
            l2 = l3 + (l3 + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return l2;
    }

    boolean hasData(BaseNCodec$Context baseNCodec$Context) {
        return baseNCodec$Context.pos > baseNCodec$Context.readPos;
    }

    protected abstract boolean isInAlphabet(byte var1);

    public boolean isInAlphabet(byte[] byArray, boolean bl2) {
        for (byte by2 : byArray) {
            if (this.isInAlphabet(by2) || bl2 && (by2 == this.pad || Character.isWhitespace(by2))) continue;
            return false;
        }
        return true;
    }

    public boolean isInAlphabet(String string) {
        return this.isInAlphabet(Strings.utf8(string), true);
    }

    public boolean isStrictDecoding() {
        return this.decodingPolicy == CodecPolicy.STRICT;
    }

    int readResults(byte[] byArray, int n2, int n3, BaseNCodec$Context baseNCodec$Context) {
        if (this.hasData(baseNCodec$Context)) {
            n3 = Math.min(this.available(baseNCodec$Context), n3);
            System.arraycopy(baseNCodec$Context.buffer, baseNCodec$Context.readPos, byArray, n2, n3);
            baseNCodec$Context.readPos += n3;
            if (!this.hasData(baseNCodec$Context)) {
                BaseNCodec$Context baseNCodec$Context2 = baseNCodec$Context;
                baseNCodec$Context2.readPos = 0;
                baseNCodec$Context2.pos = 0;
            }
            return n3;
        }
        if (baseNCodec$Context.eof) {
            return -1;
        }
        return 0;
    }
}

