/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import java.io.Reader;
import java.io.Serializable;
import java.util.Objects;

public class CharSequenceReader
extends Reader
implements Serializable {
    private static final long serialVersionUID = 3724187752191401220L;
    private final CharSequence charSequence;
    private int idx;
    private int mark;
    private final int start;
    private final Integer end;

    public CharSequenceReader(CharSequence charSequence) {
        this(charSequence, 0);
    }

    public CharSequenceReader(CharSequence charSequence, int n2) {
        this(charSequence, n2, Integer.MAX_VALUE);
    }

    public CharSequenceReader(CharSequence charSequence, int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Start index is less than zero: " + n2);
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("End index is less than start " + n2 + ": " + n3);
        }
        this.charSequence = charSequence != null ? charSequence : "";
        this.start = n2;
        this.end = n3;
        this.idx = n2;
        this.mark = n2;
    }

    @Override
    public void close() {
        this.idx = this.start;
        this.mark = this.start;
    }

    private int end() {
        return Math.min(this.charSequence.length(), this.end == null ? Integer.MAX_VALUE : this.end);
    }

    @Override
    public void mark(int n2) {
        this.mark = this.idx;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this.idx >= this.end()) {
            return -1;
        }
        return this.charSequence.charAt(this.idx++);
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        if (this.idx >= this.end()) {
            return -1;
        }
        Objects.requireNonNull(cArray, "array");
        if (n3 < 0 || n2 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("Array Size=" + cArray.length + ", offset=" + n2 + ", length=" + n3);
        }
        if (this.charSequence instanceof String) {
            int n4 = Math.min(n3, this.end() - this.idx);
            ((String)this.charSequence).getChars(this.idx, this.idx + n4, cArray, n2);
            this.idx += n4;
            return n4;
        }
        if (this.charSequence instanceof StringBuilder) {
            int n5 = Math.min(n3, this.end() - this.idx);
            ((StringBuilder)this.charSequence).getChars(this.idx, this.idx + n5, cArray, n2);
            this.idx += n5;
            return n5;
        }
        if (this.charSequence instanceof StringBuffer) {
            int n6 = Math.min(n3, this.end() - this.idx);
            ((StringBuffer)this.charSequence).getChars(this.idx, this.idx + n6, cArray, n2);
            this.idx += n6;
            return n6;
        }
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n8 = this.read();
            if (n8 == -1) {
                return n7;
            }
            cArray[n2 + i2] = (char)n8;
            ++n7;
        }
        return n7;
    }

    @Override
    public boolean ready() {
        return this.idx < this.end();
    }

    @Override
    public void reset() {
        this.idx = this.mark;
    }

    @Override
    public long skip(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Number of characters to skip is less than zero: " + l2);
        }
        if (this.idx >= this.end()) {
            return 0L;
        }
        int n2 = (int)Math.min((long)this.end(), (long)this.idx + l2);
        int n3 = n2 - this.idx;
        this.idx = n2;
        return n3;
    }

    private int start() {
        return Math.min(this.charSequence.length(), this.start);
    }

    public String toString() {
        CharSequence charSequence = this.charSequence.subSequence(this.start(), this.end());
        return charSequence.toString();
    }
}

