/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public class CountingInputStream
extends FilterInputStream {
    private final AtomicLong count = new AtomicLong(0L);

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public long getCount() {
        return this.count.get();
    }

    private void add(long l2) {
        if (l2 > 0L) {
            this.count.addAndGet(l2);
        }
    }

    @Override
    public int read() throws IOException {
        int n2 = super.read();
        this.add(n2 == -1 ? -1L : 1L);
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n2 = super.read(byArray);
        this.add(n2);
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = super.read(byArray, n2, n3);
        this.add(n4);
        return n4;
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = super.skip(l2);
        this.add(l3);
        return l3;
    }
}

