/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import io.jsonwebtoken.impl.lang.Bytes;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class FilteredInputStream
extends FilterInputStream {
    public FilteredInputStream(InputStream inputStream) {
        super(inputStream);
    }

    protected void afterRead(int n2) throws IOException {
    }

    @Override
    public int available() throws IOException {
        try {
            return super.available();
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return 0;
        }
    }

    protected void beforeRead(int n2) throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
            return;
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return;
        }
    }

    protected void onThrowable(Throwable throwable) throws IOException {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        throw new IOException("IO Exception: " + throwable.getMessage(), throwable);
    }

    @Override
    public synchronized void mark(int n2) {
        this.in.mark(n2);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            this.beforeRead(1);
            int n2 = this.in.read();
            this.afterRead(n2 != -1 ? 1 : -1);
            return n2;
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return -1;
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        try {
            this.beforeRead(Bytes.length(byArray));
            int n2 = this.in.read(byArray);
            this.afterRead(n2);
            return n2;
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return -1;
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.beforeRead(n3);
            int n4 = this.in.read(byArray, n2, n3);
            this.afterRead(n4);
            return n4;
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return -1;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.in.reset();
            return;
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return;
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        try {
            return this.in.skip(l2);
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return 0L;
        }
    }
}

