/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import io.jsonwebtoken.impl.lang.Bytes;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FilteredOutputStream
extends FilterOutputStream {
    public FilteredOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    protected void afterWrite(int n2) throws IOException {
    }

    protected void beforeWrite(int n2) throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
            return;
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
            return;
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return;
        }
    }

    protected void onThrowable(Throwable throwable) throws IOException {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        throw new IOException("IO Exception " + throwable.getMessage(), throwable);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        try {
            int n2 = Bytes.length(byArray);
            this.beforeWrite(n2);
            this.out.write(byArray);
            this.afterWrite(n2);
            return;
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.beforeWrite(n3);
            this.out.write(byArray, n2, n3);
            this.afterWrite(n3);
            return;
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return;
        }
    }

    @Override
    public void write(int n2) throws IOException {
        try {
            this.beforeWrite(1);
            this.out.write(n2);
            this.afterWrite(1);
            return;
        }
        catch (Throwable throwable) {
            this.onThrowable(throwable);
            return;
        }
    }
}

