/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.security.Randoms;
import io.jsonwebtoken.lang.Assert;
import java.util.Arrays;

public final class Bytes {
    public static final byte[] EMPTY = new byte[0];
    private static final int LONG_BYTE_LENGTH = 8;
    private static final int INT_BYTE_LENGTH = 4;
    public static final String LONG_REQD_MSG = "Long byte arrays must be 8 bytes in length.";
    public static final String INT_REQD_MSG = "Integer byte arrays must be 4 bytes in length.";

    private Bytes() {
    }

    public static byte[] nullSafe(byte[] byArray) {
        if (byArray != null) {
            return byArray;
        }
        return EMPTY;
    }

    public static byte[] randomBits(int n2) {
        return Bytes.random(n2 / 8);
    }

    public static byte[] random(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("numBytes argument must be >= 0");
        }
        byte[] byArray = new byte[n2];
        Randoms.secureRandom().nextBytes(byArray);
        return byArray;
    }

    public static byte[] toBytes(int n2) {
        return new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2};
    }

    public static byte[] toBytes(long l2) {
        return new byte[]{(byte)(l2 >>> 56), (byte)(l2 >>> 48), (byte)(l2 >>> 40), (byte)(l2 >>> 32), (byte)(l2 >>> 24), (byte)(l2 >>> 16), (byte)(l2 >>> 8), (byte)l2};
    }

    public static long toLong(byte[] byArray) {
        Assert.isTrue(io.jsonwebtoken.lang.Arrays.length(byArray) == 8, LONG_REQD_MSG);
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    public static int toInt(byte[] byArray) {
        Assert.isTrue(io.jsonwebtoken.lang.Arrays.length(byArray) == 4, INT_REQD_MSG);
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) {
        return Bytes.indexOf(byArray, byArray2, 0);
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n2) {
        return Bytes.indexOf(byArray, 0, Bytes.length(byArray), byArray2, 0, Bytes.length(byArray2), n2);
    }

    static int indexOf(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, int n6) {
        if (n6 >= n3) {
            if (n5 == 0) {
                return n3;
            }
            return -1;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 == 0) {
            return n6;
        }
        byte by2 = byArray2[n4];
        n3 = n2 + (n3 - n5);
        for (n6 = n2 + n6; n6 <= n3; ++n6) {
            if (byArray[n6] != by2) {
                while (++n6 <= n3 && byArray[n6] != by2) {
                }
            }
            if (n6 > n3) continue;
            int n7 = n6 + 1;
            int n8 = n7 + n5 - 1;
            int n9 = n4 + 1;
            while (n7 < n8 && byArray[n7] == byArray2[n9]) {
                ++n7;
                ++n9;
            }
            if (n7 != n8) continue;
            return n6 - n2;
        }
        return -1;
    }

    public static boolean startsWith(byte[] byArray, byte[] byArray2) {
        return Bytes.startsWith(byArray, byArray2, 0);
    }

    public static boolean startsWith(byte[] byArray, byte[] byArray2, int n2) {
        int n3 = n2;
        int n4 = 0;
        int n5 = Bytes.length(byArray2);
        if (n2 < 0 || n2 > Bytes.length(byArray) - n5) {
            return false;
        }
        while (--n5 >= 0) {
            if (byArray[n3++] == byArray2[n4++]) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(byte[] byArray, byte[] byArray2) {
        return Bytes.startsWith(byArray, byArray2, Bytes.length(byArray) - Bytes.length(byArray2));
    }

    public static byte[] concat(byte[] ... byArray) {
        int n2 = 0;
        int n3 = io.jsonwebtoken.lang.Arrays.length(byArray);
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += Bytes.length(byArray[i2]);
        }
        byte[] byArray2 = new byte[n2];
        n3 = 0;
        if (n2 > 0) {
            for (byte[] byArray3 : byArray) {
                int n4 = Bytes.length(byArray3);
                if (n4 <= 0) continue;
                System.arraycopy(byArray3, 0, byArray2, n3, n4);
                n3 += n4;
            }
        }
        return byArray2;
    }

    public static void clear(byte[] byArray) {
        if (Bytes.isEmpty(byArray)) {
            return;
        }
        Arrays.fill(byArray, (byte)0);
    }

    public static boolean isEmpty(byte[] byArray) {
        return Bytes.length(byArray) == 0;
    }

    public static int length(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        return byArray.length;
    }

    public static long bitLength(byte[] byArray) {
        return (long)Bytes.length(byArray) << 3;
    }

    public static int length(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("bitLength argument must be >= 0");
        }
        return (n2 + 7) / 8;
    }

    public static String bitsMsg(long l2) {
        return l2 + " bits (" + l2 / 8L + " bytes)";
    }

    public static String bytesMsg(int n2) {
        return Bytes.bitsMsg((long)n2 << 3);
    }

    public static void increment(byte[] byArray) {
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            int n3 = n2--;
            byArray[n3] = (byte)(byArray[n3] + 1);
            if (byArray[n3] == 0) continue;
        }
    }

    public static byte[] prepad(byte[] byArray, int n2) {
        Assert.notNull(byArray, "byte array cannot be null.");
        Assert.gt(n2, 0, "length must be positive (> 0).");
        if (byArray.length < n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
            byArray = byArray2;
        }
        return byArray;
    }
}

