/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.DateFormats;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class JwtDateConverter
implements Converter<Date, Object> {
    public static final JwtDateConverter INSTANCE = new JwtDateConverter();

    @Override
    public Object applyTo(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime() / 1000L;
    }

    @Override
    public Date applyFrom(Object object) {
        return JwtDateConverter.toSpecDate(object);
    }

    public static Date toSpecDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            try {
                object = Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (object instanceof Number) {
            long l2 = ((Number)object).longValue();
            object = l2 * 1000L;
        }
        return JwtDateConverter.toDate(object);
    }

    public static Date toDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        if (object instanceof Number) {
            long l2 = ((Number)object).longValue();
            return new Date(l2);
        }
        if (object instanceof String) {
            return JwtDateConverter.parseIso8601Date((String)object);
        }
        String string = "Cannot create Date from object of type " + object.getClass().getName() + ".";
        throw new IllegalArgumentException(string);
    }

    private static Date parseIso8601Date(String string) throws IllegalArgumentException {
        try {
            return DateFormats.parseIso8601Date(string);
        }
        catch (ParseException parseException) {
            String string2 = "String value is not a JWT NumericDate, nor is it ISO-8601-formatted. All heuristics exhausted. Cause: " + parseException.getMessage();
            throw new IllegalArgumentException(string2, parseException);
        }
    }
}

