/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.lang.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class NestedIdentifiableCollection<E extends Identifiable, P>
implements NestedCollection<E, P> {
    private final P PARENT;
    private final Map<String, E> VALUES;

    private static <K, V> Map<K, V> nullSafe(Map<K, V> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public NestedIdentifiableCollection(P p2, Map<String, ? extends E> map) {
        this.PARENT = Assert.notNull(p2, "parent cannot be null.");
        this.VALUES = new LinkedHashMap<String, E>(NestedIdentifiableCollection.nullSafe(map));
    }

    protected final String assertId(E object) {
        Assert.notNull(object, "Identifiable instance cannot be null.");
        String string = object.getId();
        if (!Strings.hasText(string)) {
            object = object.getClass() + " getId() cannot be null or empty.";
            throw new IllegalArgumentException((String)object);
        }
        return string;
    }

    private boolean doAdd(E e2) {
        String string = this.assertId(e2);
        this.VALUES.put(string, e2);
        return true;
    }

    @Override
    public NestedCollection<E, P> add(E e2) {
        if (e2 != null) {
            this.doAdd(e2);
            this.changed();
        }
        return this;
    }

    @Override
    public NestedCollection<E, P> remove(E object) {
        if (object != null) {
            object = this.assertId(object);
            if ((object = (Identifiable)this.VALUES.remove(object)) != null) {
                this.changed();
            }
        }
        return this;
    }

    @Override
    public NestedCollection<E, P> clear() {
        if (!Collections.isEmpty(this.VALUES)) {
            this.VALUES.clear();
            this.changed();
        }
        return this;
    }

    @Override
    public NestedCollection<E, P> add(Collection<? extends E> object) {
        boolean bl2 = false;
        for (Identifiable identifiable : Collections.nullSafe(object)) {
            bl2 = this.doAdd(identifiable) || bl2;
        }
        if (bl2) {
            this.changed();
        }
        return this;
    }

    @Override
    public P and() {
        return this.PARENT;
    }

    protected void changed() {
    }

    protected final Map<String, E> getValues() {
        return Collections.immutable(this.VALUES);
    }
}

