/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;

public class RequiredBitLengthConverter
implements Converter<byte[], Object> {
    private final Converter<byte[], Object> converter;
    private final int bitLength;
    private final boolean exact;

    public RequiredBitLengthConverter(Converter<byte[], Object> converter, int n2) {
        this(converter, n2, true);
    }

    public RequiredBitLengthConverter(Converter<byte[], Object> converter, int n2, boolean bl2) {
        this.converter = Assert.notNull(converter, "Converter cannot be null.");
        this.bitLength = Assert.gt(n2, 0, "bitLength must be greater than 0");
        this.exact = bl2;
    }

    private byte[] assertLength(byte[] object) {
        long l2 = Bytes.bitLength(object);
        if (this.exact && l2 != (long)this.bitLength) {
            object = "Byte array must be exactly " + Bytes.bitsMsg(this.bitLength) + ". Found " + Bytes.bitsMsg(l2);
            throw new IllegalArgumentException((String)object);
        }
        if (l2 < (long)this.bitLength) {
            object = "Byte array must be at least " + Bytes.bitsMsg(this.bitLength) + ". Found " + Bytes.bitsMsg(l2);
            throw new IllegalArgumentException((String)object);
        }
        return object;
    }

    @Override
    public Object applyTo(byte[] byArray) {
        this.assertLength(byArray);
        return this.converter.applyTo(byArray);
    }

    @Override
    public byte[] applyFrom(Object object) {
        object = this.converter.applyFrom(object);
        return this.assertLength((byte[])object);
    }
}

