/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.impl.lang.Nameable;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.MalformedKeyException;

public class RequiredParameterReader
implements ParameterReadable {
    private final ParameterReadable src;

    public RequiredParameterReader(Header header) {
        this(Assert.isInstanceOf(ParameterReadable.class, header, "Header implementations must implement ParameterReadable: "));
    }

    public RequiredParameterReader(ParameterReadable parameterReadable) {
        this.src = Assert.notNull(parameterReadable, "Source ParameterReadable cannot be null.");
        Assert.isInstanceOf(Nameable.class, parameterReadable, "ParameterReadable implementations must implement Nameable.");
    }

    private String name() {
        return ((Nameable)((Object)this.src)).getName();
    }

    private JwtException malformed(String string) {
        if (this.src instanceof JwkContext || this.src instanceof Jwk) {
            return new MalformedKeyException(string);
        }
        return new MalformedJwtException(string);
    }

    @Override
    public <T> T get(Parameter<T> object) {
        T t2 = this.src.get(object);
        if (t2 == null) {
            object = this.name() + " is missing required " + object + " value.";
            throw this.malformed((String)object);
        }
        return t2;
    }
}

