/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.ParameterMap;
import io.jsonwebtoken.impl.security.AbstractJwkBuilder;
import io.jsonwebtoken.impl.security.DefaultKeyUseStrategy;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.KeyUseStrategy;
import io.jsonwebtoken.impl.security.X509BuilderSupport;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.AsymmetricJwk;
import io.jsonwebtoken.security.AsymmetricJwkBuilder;
import io.jsonwebtoken.security.MalformedKeyException;
import java.net.URI;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;

abstract class AbstractAsymmetricJwkBuilder<K extends Key, J extends AsymmetricJwk<K>, T extends AsymmetricJwkBuilder<K, J, T>>
extends AbstractJwkBuilder<K, J, T>
implements AsymmetricJwkBuilder<K, J, T> {
    protected Boolean applyX509KeyUse = null;
    private KeyUseStrategy keyUseStrategy = DefaultKeyUseStrategy.INSTANCE;
    private final X509BuilderSupport x509;

    public AbstractAsymmetricJwkBuilder(JwkContext<K> map) {
        super(map);
        map = Assert.isInstanceOf(ParameterMap.class, this.DELEGATE);
        this.x509 = new X509BuilderSupport((ParameterMap)map, (Class<? extends RuntimeException>)MalformedKeyException.class);
    }

    AbstractAsymmetricJwkBuilder(AbstractAsymmetricJwkBuilder<?, ?, ?> abstractAsymmetricJwkBuilder, JwkContext<K> jwkContext) {
        this(jwkContext);
        this.applyX509KeyUse = abstractAsymmetricJwkBuilder.applyX509KeyUse;
        this.keyUseStrategy = abstractAsymmetricJwkBuilder.keyUseStrategy;
    }

    @Override
    public T publicKeyUse(String string) {
        Assert.hasText(string, "publicKeyUse cannot be null or empty.");
        ((JwkContext)this.DELEGATE).setPublicKeyUse(string);
        return (T)((AsymmetricJwkBuilder)this.self());
    }

    @Override
    public T x509Chain(List<X509Certificate> list) {
        Assert.notEmpty(list, "X509Certificate chain cannot be null or empty.");
        this.x509.x509Chain((List)list);
        return (T)((AsymmetricJwkBuilder)this.self());
    }

    @Override
    public T x509Url(URI uRI) {
        Assert.notNull(uRI, "X509Url cannot be null.");
        this.x509.x509Url(uRI);
        return (T)((AsymmetricJwkBuilder)this.self());
    }

    @Override
    public T x509Sha1Thumbprint(byte[] byArray) {
        this.x509.x509Sha1Thumbprint(byArray);
        return (T)((AsymmetricJwkBuilder)this.self());
    }

    @Override
    public T x509Sha256Thumbprint(byte[] byArray) {
        this.x509.x509Sha256Thumbprint(byArray);
        return (T)((AsymmetricJwkBuilder)this.self());
    }

    @Override
    public T x509Sha1Thumbprint(boolean bl2) {
        this.x509.x509Sha1Thumbprint(bl2);
        return (T)((AsymmetricJwkBuilder)this.self());
    }

    @Override
    public T x509Sha256Thumbprint(boolean bl2) {
        this.x509.x509Sha256Thumbprint(bl2);
        return (T)((AsymmetricJwkBuilder)this.self());
    }

    @Override
    public J build() {
        this.x509.apply();
        return (J)((AsymmetricJwk)super.build());
    }

    static /* synthetic */ Map access$000(AbstractAsymmetricJwkBuilder abstractAsymmetricJwkBuilder) {
        return abstractAsymmetricJwkBuilder.DELEGATE;
    }
}

