/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.CheckedFunction;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory$1;
import io.jsonwebtoken.impl.security.DefaultJwkContext;
import io.jsonwebtoken.impl.security.FamilyJwkFactory;
import io.jsonwebtoken.impl.security.JcaTemplate;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.Jwk;
import java.security.Key;
import java.security.KeyFactory;
import java.util.Set;

abstract class AbstractFamilyJwkFactory<K extends Key, J extends Jwk<K>>
implements FamilyJwkFactory<K, J> {
    private final String ktyValue;
    private final Class<K> keyType;
    private final Set<Parameter<?>> params;

    protected static <T> void put(JwkContext<?> jwkContext, Parameter<T> parameter, T t2) {
        jwkContext.put(parameter.getId(), parameter.applyTo(t2));
    }

    AbstractFamilyJwkFactory(String string, Class<K> clazz, Set<Parameter<?>> set) {
        this.ktyValue = Assert.hasText(string, "keyType argument cannot be null or empty.");
        this.keyType = Assert.notNull(clazz, "keyType class cannot be null.");
        this.params = Assert.notEmpty(set, "Parameters collection cannot be null or empty.");
    }

    @Override
    public String getId() {
        return this.ktyValue;
    }

    @Override
    public boolean supports(Key key) {
        return this.keyType.isInstance(key);
    }

    @Override
    public JwkContext<K> newContext(JwkContext<?> jwkContext, K k2) {
        Assert.notNull(jwkContext, "Source JwkContext cannot be null.");
        if (k2 != null) {
            return new DefaultJwkContext<K>(this.params, jwkContext, k2);
        }
        return new DefaultJwkContext(this.params, jwkContext, false);
    }

    @Override
    public boolean supports(JwkContext<?> jwkContext) {
        return this.supports((Key)jwkContext.getKey()) || this.supportsKeyValues(jwkContext);
    }

    protected boolean supportsKeyValues(JwkContext<?> jwkContext) {
        return this.ktyValue.equals(jwkContext.getType());
    }

    protected K generateKey(JwkContext<K> jwkContext, CheckedFunction<KeyFactory, K> checkedFunction) {
        return this.generateKey(jwkContext, this.keyType, checkedFunction);
    }

    protected String getKeyFactoryJcaName(JwkContext<?> object) {
        if (Strings.hasText((String)(object = KeysBridge.findAlgorithm(object.getKey())))) {
            return object;
        }
        return this.getId();
    }

    protected <T extends Key> T generateKey(JwkContext<?> jwkContext, Class<T> clazz, CheckedFunction<KeyFactory, T> checkedFunction) {
        Object object = this.getKeyFactoryJcaName(jwkContext);
        object = new JcaTemplate((String)object, jwkContext.getProvider(), jwkContext.getRandom());
        return (T)((Key)((JcaTemplate)object).withKeyFactory(new AbstractFamilyJwkFactory$1(this, checkedFunction, clazz, jwkContext)));
    }

    @Override
    public final J createJwk(JwkContext<K> jwkContext) {
        Assert.notNull(jwkContext, "JwkContext argument cannot be null.");
        if (!this.supports(jwkContext)) {
            String string = "Unsupported JwkContext.";
            throw new IllegalArgumentException(string);
        }
        K k2 = jwkContext.getKey();
        if (k2 != null) {
            jwkContext.setType(this.ktyValue);
            return this.createJwkFromKey(jwkContext);
        }
        return this.createJwkFromValues(jwkContext);
    }

    protected abstract J createJwkFromKey(JwkContext<K> var1);

    protected abstract J createJwkFromValues(JwkContext<K> var1);
}

