/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.security.AbstractAsymmetricJwk;
import io.jsonwebtoken.impl.security.DefaultKeyPair;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.KeyPair;
import io.jsonwebtoken.security.PrivateJwk;
import io.jsonwebtoken.security.PublicJwk;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;

abstract class AbstractPrivateJwk<K extends PrivateKey, L extends PublicKey, M extends PublicJwk<L>>
extends AbstractAsymmetricJwk<K>
implements PrivateJwk<K, L, M> {
    private final M publicJwk;
    private final KeyPair<L, K> keyPair;

    AbstractPrivateJwk(JwkContext<K> object, List<Parameter<?>> list, M m2) {
        super(object, list);
        this.publicJwk = (PublicJwk)Assert.notNull(m2, "PublicJwk instance cannot be null.");
        object = (PublicKey)Assert.notNull(m2.toKey(), "PublicJwk key instance cannot be null.");
        this.context.setPublicKey((PublicKey)object);
        this.keyPair = new DefaultKeyPair<Object, PrivateKey>(object, (PrivateKey)this.toKey());
    }

    @Override
    public M toPublicJwk() {
        return this.publicJwk;
    }

    @Override
    public KeyPair<L, K> toKeyPair() {
        return this.keyPair;
    }

    @Override
    protected final boolean equals(Jwk<?> jwk) {
        return jwk instanceof PrivateJwk && this.equals((PrivateJwk)jwk);
    }

    protected abstract boolean equals(PrivateJwk<?, ?, ?> var1);
}

