/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.AbstractSecureDigestAlgorithm;
import io.jsonwebtoken.impl.security.AbstractSignatureAlgorithm$1;
import io.jsonwebtoken.impl.security.AbstractSignatureAlgorithm$2;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SignatureAlgorithm;
import io.jsonwebtoken.security.VerifySecureDigestRequest;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.text.MessageFormat;

abstract class AbstractSignatureAlgorithm
extends AbstractSecureDigestAlgorithm<PrivateKey, PublicKey>
implements SignatureAlgorithm {
    private static final String KEY_TYPE_MSG_PATTERN = "{0} {1} keys must be {2}s (implement {3}). Provided key type: {4}.";

    AbstractSignatureAlgorithm(String string, String string2) {
        super(string, string2);
    }

    @Override
    protected void validateKey(Key object, boolean bl2) {
        Class clazz = bl2 ? PrivateKey.class : PublicKey.class;
        if (!clazz.isInstance(object)) {
            object = MessageFormat.format(KEY_TYPE_MSG_PATTERN, this.getId(), AbstractSignatureAlgorithm.keyType(bl2), clazz.getSimpleName(), clazz.getName(), object.getClass().getName());
            throw new InvalidKeyException((String)object);
        }
    }

    protected final byte[] sign(Signature signature, InputStream inputStream) throws Exception {
        byte[] byArray = new byte[2048];
        int n2 = 0;
        while (n2 != -1) {
            n2 = inputStream.read(byArray);
            if (n2 <= 0) continue;
            signature.update(byArray, 0, n2);
        }
        return signature.sign();
    }

    @Override
    protected byte[] doDigest(SecureRequest<InputStream, PrivateKey> secureRequest) {
        return this.jca(secureRequest).withSignature(new AbstractSignatureAlgorithm$1(this, secureRequest));
    }

    protected boolean verify(Signature signature, InputStream inputStream, byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[1024];
        int n2 = 0;
        while (n2 != -1) {
            n2 = inputStream.read(byArray2);
            if (n2 <= 0) continue;
            signature.update(byArray2, 0, n2);
        }
        return signature.verify(byArray);
    }

    @Override
    protected boolean doVerify(VerifySecureDigestRequest<PublicKey> verifySecureDigestRequest) {
        return this.jca(verifySecureDigestRequest).withSignature(new AbstractSignatureAlgorithm$2(this, verifySecureDigestRequest));
    }
}

