/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.security.CryptoAlgorithm;
import io.jsonwebtoken.impl.security.DefaultSecretKeyBuilder;
import io.jsonwebtoken.lang.Arrays;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.IvSupplier;
import io.jsonwebtoken.security.KeyBuilderSupplier;
import io.jsonwebtoken.security.KeyLengthSupplier;
import io.jsonwebtoken.security.Request;
import io.jsonwebtoken.security.SecretKeyBuilder;
import io.jsonwebtoken.security.WeakKeyException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class AesAlgorithm
extends CryptoAlgorithm
implements KeyBuilderSupplier<SecretKey, SecretKeyBuilder>,
KeyLengthSupplier {
    protected static final String KEY_ALG_NAME = "AES";
    protected static final int BLOCK_SIZE = 128;
    protected static final int BLOCK_BYTE_SIZE = 16;
    protected static final int GCM_IV_SIZE = 96;
    protected static final String DECRYPT_NO_IV = "This algorithm implementation rejects decryption requests that do not include initialization vectors. AES ciphertext without an IV is weak and susceptible to attack.";
    protected final int keyBitLength;
    protected final int ivBitLength;
    protected final int tagBitLength;
    protected final boolean gcm;

    static void assertKeyBitLength(int n2) {
        if (n2 == 128 || n2 == 192 || n2 == 256) {
            return;
        }
        String string = "Invalid AES key length: " + Bytes.bitsMsg(n2) + ". AES only supports 128, 192, or 256 bit keys.";
        throw new IllegalArgumentException(string);
    }

    static SecretKey keyFor(byte[] byArray) {
        int n2 = (int)Bytes.bitLength(byArray);
        AesAlgorithm.assertKeyBitLength(n2);
        return new SecretKeySpec(byArray, KEY_ALG_NAME);
    }

    AesAlgorithm(String string, String string2, int n2) {
        super(string, string2);
        AesAlgorithm.assertKeyBitLength(n2);
        this.keyBitLength = n2;
        this.gcm = string2.startsWith("AES/GCM");
        this.ivBitLength = string2.equals("AESWrap") ? 0 : (this.gcm ? 96 : 128);
        this.tagBitLength = this.gcm ? 128 : this.keyBitLength;
    }

    @Override
    public int getKeyBitLength() {
        return this.keyBitLength;
    }

    @Override
    public SecretKeyBuilder key() {
        return new DefaultSecretKeyBuilder(KEY_ALG_NAME, this.getKeyBitLength());
    }

    protected SecretKey assertKey(SecretKey secretKey) {
        Assert.notNull(secretKey, "Request key cannot be null.");
        this.validateLengthIfPossible(secretKey);
        return secretKey;
    }

    private void validateLengthIfPossible(SecretKey secretKey) {
        this.validateLength(secretKey, this.keyBitLength, false);
    }

    protected static String lengthMsg(String string, String string2, int n2, long l2) {
        return "The '" + string + "' algorithm requires " + string2 + " with a length of " + Bytes.bitsMsg(n2) + ".  The provided key has a length of " + Bytes.bitsMsg(l2) + ".";
    }

    protected byte[] validateLength(SecretKey object, int n2, boolean bl2) {
        try {
            object = object.getEncoded();
        }
        catch (RuntimeException runtimeException) {
            if (bl2) {
                throw runtimeException;
            }
            return null;
        }
        long l2 = Bytes.bitLength((byte[])object);
        if (l2 < (long)n2) {
            throw new WeakKeyException(AesAlgorithm.lengthMsg(this.getId(), "keys", n2, l2));
        }
        return object;
    }

    protected byte[] assertBytes(byte[] object, String string, int n2) {
        long l2 = Bytes.bitLength(object);
        if ((long)n2 != l2) {
            object = AesAlgorithm.lengthMsg(this.getId(), string, n2, l2);
            throw new IllegalArgumentException((String)object);
        }
        return object;
    }

    byte[] assertIvLength(byte[] byArray) {
        return this.assertBytes(byArray, "initialization vectors", this.ivBitLength);
    }

    byte[] assertTag(byte[] byArray) {
        return this.assertBytes(byArray, "authentication tags", this.tagBitLength);
    }

    byte[] assertDecryptionIv(IvSupplier object) throws IllegalArgumentException {
        byte[] byArray = object.getIv();
        object = byArray;
        Assert.notEmpty(byArray, DECRYPT_NO_IV);
        return this.assertIvLength((byte[])object);
    }

    protected byte[] ensureInitializationVector(Request<?> object) {
        byte[] byArray = null;
        if (object instanceof IvSupplier) {
            byArray = Arrays.clean(((IvSupplier)object).getIv());
        }
        int n2 = this.ivBitLength / 8;
        if (byArray == null || byArray.length == 0) {
            byArray = new byte[n2];
            object = AesAlgorithm.ensureSecureRandom(object);
            ((SecureRandom)object).nextBytes(byArray);
        } else {
            this.assertIvLength(byArray);
        }
        return byArray;
    }

    protected AlgorithmParameterSpec getIvSpec(byte[] byArray) {
        Assert.notEmpty(byArray, "Initialization Vector byte array cannot be null or empty.");
        if (this.gcm) {
            return new GCMParameterSpec(128, byArray);
        }
        return new IvParameterSpec(byArray);
    }

    protected void withCipher(Cipher object, InputStream inputStream, OutputStream outputStream) throws Exception {
        object = this.withCipher((Cipher)object, inputStream, null, outputStream);
        outputStream.write((byte[])object);
    }

    private void updateAAD(Cipher cipher, InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return;
        }
        byte[] byArray = new byte[2048];
        int n2 = 0;
        while (n2 != -1) {
            n2 = inputStream.read(byArray);
            if (n2 <= 0) continue;
            cipher.updateAAD(byArray, 0, n2);
        }
    }

    protected byte[] withCipher(Cipher cipher, InputStream inputStream, InputStream object, OutputStream outputStream) throws Exception {
        this.updateAAD(cipher, (InputStream)object);
        object = new byte[2048];
        try {
            byte[] byArray;
            int n2 = 0;
            while (n2 != -1) {
                n2 = inputStream.read((byte[])object);
                if (n2 <= 0) continue;
                byArray = cipher.update((byte[])object, 0, n2);
                Streams.write(outputStream, byArray, "Unable to write Cipher output to OutputStream");
            }
            byArray = cipher.doFinal();
            return byArray;
        }
        finally {
            Bytes.clear((byte[])object);
        }
    }
}

