/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.impl.security.JcaTemplate;
import io.jsonwebtoken.impl.security.Randoms;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.KeyRequest;
import io.jsonwebtoken.security.Request;
import io.jsonwebtoken.security.SecretKeyBuilder;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.SecretKey;

abstract class CryptoAlgorithm
implements Identifiable {
    private final String ID;
    private final String jcaName;

    CryptoAlgorithm(String string, String string2) {
        Assert.hasText(string, "id cannot be null or empty.");
        this.ID = string;
        Assert.hasText(string2, "jcaName cannot be null or empty.");
        this.jcaName = string2;
    }

    @Override
    public String getId() {
        return this.ID;
    }

    String getJcaName() {
        return this.jcaName;
    }

    static SecureRandom ensureSecureRandom(Request<?> object) {
        if ((object = object != null ? object.getSecureRandom() : null) != null) {
            return object;
        }
        return Randoms.secureRandom();
    }

    protected JcaTemplate jca() {
        return new JcaTemplate(this.getJcaName());
    }

    protected JcaTemplate jca(Request<?> object) {
        Assert.notNull(object, "request cannot be null.");
        String string = Assert.hasText(this.getJcaName((Request<?>)object), "Request jcaName cannot be null or empty.");
        Provider provider = object.getProvider();
        object = CryptoAlgorithm.ensureSecureRandom(object);
        return new JcaTemplate(string, provider, (SecureRandom)object);
    }

    protected String getJcaName(Request<?> request) {
        return this.getJcaName();
    }

    protected SecretKey generateCek(KeyRequest<?> object) {
        Object object2 = Assert.notNull(object.getEncryptionAlgorithm(), "Request encryptionAlgorithm cannot be null.");
        object2 = (SecretKeyBuilder)Assert.notNull(object2.key(), "Request encryptionAlgorithm KeyBuilder cannot be null.");
        object = (SecretKey)((SecretKeyBuilder)object2.random(object.getSecureRandom())).build();
        return Assert.notNull(object, "Request encryptionAlgorithm SecretKeyBuilder cannot produce null keys.");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CryptoAlgorithm) {
            return this.ID.equals(((CryptoAlgorithm)(object = (CryptoAlgorithm)object)).getId()) && this.jcaName.equals(((CryptoAlgorithm)object).getJcaName());
        }
        return false;
    }

    public int hashCode() {
        int n2 = 217 + this.ID.hashCode();
        n2 = n2 * 31 + this.jcaName.hashCode();
        return n2;
    }

    public String toString() {
        return this.ID;
    }
}

