/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.impl.security.DefaultKeyRequest;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.AeadAlgorithm;
import io.jsonwebtoken.security.DecryptionKeyRequest;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;

public class DefaultDecryptionKeyRequest<K extends Key>
extends DefaultKeyRequest<byte[]>
implements DecryptionKeyRequest<K> {
    private final K decryptionKey;

    public DefaultDecryptionKeyRequest(byte[] byArray, Provider provider, SecureRandom secureRandom, JweHeader jweHeader, AeadAlgorithm aeadAlgorithm, K k2) {
        super(byArray, provider, secureRandom, jweHeader, aeadAlgorithm);
        this.decryptionKey = (Key)Assert.notNull(k2, "decryption key cannot be null.");
    }

    @Override
    protected void assertBytePayload(byte[] byArray) {
        Assert.notNull(byArray, "encrypted key bytes cannot be null (but may be empty.");
    }

    @Override
    public K getKey() {
        return this.decryptionKey;
    }
}

