/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.AbstractAsymmetricJwkBuilder$DefaultEcPrivateJwkBuilder;
import io.jsonwebtoken.impl.security.AbstractAsymmetricJwkBuilder$DefaultEcPublicJwkBuilder;
import io.jsonwebtoken.impl.security.AbstractAsymmetricJwkBuilder$DefaultOctetPrivateJwkBuilder;
import io.jsonwebtoken.impl.security.AbstractAsymmetricJwkBuilder$DefaultOctetPublicJwkBuilder;
import io.jsonwebtoken.impl.security.AbstractAsymmetricJwkBuilder$DefaultRsaPrivateJwkBuilder;
import io.jsonwebtoken.impl.security.AbstractAsymmetricJwkBuilder$DefaultRsaPublicJwkBuilder;
import io.jsonwebtoken.impl.security.AbstractJwk;
import io.jsonwebtoken.impl.security.AbstractJwkBuilder;
import io.jsonwebtoken.impl.security.AbstractJwkBuilder$DefaultSecretJwkBuilder;
import io.jsonwebtoken.impl.security.DefaultJwkContext;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.KeyPairs;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.DynamicJwkBuilder;
import io.jsonwebtoken.security.EcPrivateJwkBuilder;
import io.jsonwebtoken.security.EcPublicJwkBuilder;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.OctetPrivateJwkBuilder;
import io.jsonwebtoken.security.OctetPublicJwkBuilder;
import io.jsonwebtoken.security.PrivateJwkBuilder;
import io.jsonwebtoken.security.PublicJwkBuilder;
import io.jsonwebtoken.security.RsaPrivateJwkBuilder;
import io.jsonwebtoken.security.RsaPublicJwkBuilder;
import io.jsonwebtoken.security.SecretJwkBuilder;
import io.jsonwebtoken.security.UnsupportedKeyException;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import javax.crypto.SecretKey;

public class DefaultDynamicJwkBuilder<K extends Key, J extends Jwk<K>>
extends AbstractJwkBuilder<K, J, DynamicJwkBuilder<K, J>>
implements DynamicJwkBuilder<K, J> {
    public DefaultDynamicJwkBuilder() {
        this(new DefaultJwkContext());
    }

    public DefaultDynamicJwkBuilder(JwkContext<K> jwkContext) {
        super(jwkContext);
    }

    @Override
    public SecretJwkBuilder key(SecretKey secretKey) {
        return new AbstractJwkBuilder$DefaultSecretJwkBuilder(this.newContext(secretKey));
    }

    @Override
    public RsaPublicJwkBuilder key(RSAPublicKey rSAPublicKey) {
        return new AbstractAsymmetricJwkBuilder$DefaultRsaPublicJwkBuilder(this.newContext(rSAPublicKey));
    }

    @Override
    public RsaPrivateJwkBuilder key(RSAPrivateKey rSAPrivateKey) {
        return new AbstractAsymmetricJwkBuilder$DefaultRsaPrivateJwkBuilder(this.newContext(rSAPrivateKey));
    }

    @Override
    public EcPublicJwkBuilder key(ECPublicKey eCPublicKey) {
        return new AbstractAsymmetricJwkBuilder$DefaultEcPublicJwkBuilder(this.newContext(eCPublicKey));
    }

    @Override
    public EcPrivateJwkBuilder key(ECPrivateKey eCPrivateKey) {
        return new AbstractAsymmetricJwkBuilder$DefaultEcPrivateJwkBuilder(this.newContext(eCPrivateKey));
    }

    private static UnsupportedKeyException unsupportedKey(Key object, Exception exception) {
        object = "There is no builder that supports specified key [" + KeysBridge.toString((Key)object) + "].";
        return new UnsupportedKeyException((String)object, exception);
    }

    @Override
    public <A extends PublicKey, B extends PrivateKey> PublicJwkBuilder<A, B, ?, ?, ?, ?> key(A a2) {
        if (a2 instanceof RSAPublicKey) {
            return this.key((RSAPublicKey)a2);
        }
        if (a2 instanceof ECPublicKey) {
            return this.key((ECPublicKey)a2);
        }
        try {
            return this.octetKey(a2);
        }
        catch (Exception exception) {
            throw DefaultDynamicJwkBuilder.unsupportedKey(a2, exception);
        }
    }

    @Override
    public <A extends PublicKey, B extends PrivateKey> PrivateJwkBuilder<B, A, ?, ?, ?> key(B b2) {
        Assert.notNull(b2, "Key cannot be null.");
        if (b2 instanceof RSAPrivateKey) {
            return this.key((RSAPrivateKey)b2);
        }
        if (b2 instanceof ECPrivateKey) {
            return this.key((ECPrivateKey)b2);
        }
        try {
            return this.octetKey(b2);
        }
        catch (Exception exception) {
            throw DefaultDynamicJwkBuilder.unsupportedKey(b2, exception);
        }
    }

    @Override
    public <A extends PublicKey, B extends PrivateKey> OctetPublicJwkBuilder<A, B> octetKey(A a2) {
        return new AbstractAsymmetricJwkBuilder$DefaultOctetPublicJwkBuilder(this.newContext(a2));
    }

    @Override
    public <A extends PrivateKey, B extends PublicKey> OctetPrivateJwkBuilder<A, B> octetKey(A a2) {
        return new AbstractAsymmetricJwkBuilder$DefaultOctetPrivateJwkBuilder(this.newContext(a2));
    }

    @Override
    public <A extends PublicKey, B extends PrivateKey> PublicJwkBuilder<A, B, ?, ?, ?, ?> chain(List<X509Certificate> list) throws UnsupportedKeyException {
        Assert.notEmpty(list, "chain cannot be null or empty.");
        Serializable serializable = Assert.notNull(list.get(0), "The first X509Certificate cannot be null.");
        serializable = Assert.notNull(serializable.getPublicKey(), "The first X509Certificate's PublicKey cannot be null.");
        return (PublicJwkBuilder)this.key(serializable).x509Chain(list);
    }

    @Override
    public RsaPublicJwkBuilder rsaChain(List<X509Certificate> list) {
        Assert.notEmpty(list, "X509Certificate chain cannot be empty.");
        Serializable serializable = list.get(0);
        serializable = serializable.getPublicKey();
        serializable = KeyPairs.assertKey((Key)serializable, RSAPublicKey.class, "The first X509Certificate's ");
        return (RsaPublicJwkBuilder)this.key((RSAPublicKey)serializable).x509Chain(list);
    }

    @Override
    public EcPublicJwkBuilder ecChain(List<X509Certificate> list) {
        Assert.notEmpty(list, "X509Certificate chain cannot be empty.");
        Serializable serializable = list.get(0);
        serializable = serializable.getPublicKey();
        serializable = KeyPairs.assertKey((Key)serializable, ECPublicKey.class, "The first X509Certificate's ");
        return (EcPublicJwkBuilder)this.key((ECPublicKey)serializable).x509Chain(list);
    }

    @Override
    public <A extends PrivateKey, B extends PublicKey> OctetPrivateJwkBuilder<A, B> octetKeyPair(KeyPair serializable) {
        PublicKey publicKey = KeyPairs.getKey(serializable, PublicKey.class);
        serializable = KeyPairs.getKey(serializable, PrivateKey.class);
        EdwardsCurve.assertEdwards(publicKey);
        EdwardsCurve.assertEdwards(serializable);
        return (OctetPrivateJwkBuilder)this.octetKey(serializable).publicKey(publicKey);
    }

    @Override
    public <A extends PublicKey, B extends PrivateKey> OctetPublicJwkBuilder<A, B> octetChain(List<X509Certificate> list) {
        Assert.notEmpty(list, "X509Certificate chain cannot be empty.");
        Serializable serializable = list.get(0);
        serializable = serializable.getPublicKey();
        Assert.notNull(serializable, "The first X509Certificate's PublicKey cannot be null.");
        EdwardsCurve.assertEdwards(serializable);
        return (OctetPublicJwkBuilder)this.octetKey(serializable).x509Chain(list);
    }

    @Override
    public RsaPrivateJwkBuilder rsaKeyPair(KeyPair serializable) {
        RSAPublicKey rSAPublicKey = KeyPairs.getKey(serializable, RSAPublicKey.class);
        serializable = KeyPairs.getKey(serializable, RSAPrivateKey.class);
        return (RsaPrivateJwkBuilder)this.key((RSAPrivateKey)serializable).publicKey(rSAPublicKey);
    }

    @Override
    public EcPrivateJwkBuilder ecKeyPair(KeyPair serializable) {
        ECPublicKey eCPublicKey = KeyPairs.getKey(serializable, ECPublicKey.class);
        serializable = KeyPairs.getKey(serializable, ECPrivateKey.class);
        return (EcPrivateJwkBuilder)this.key((ECPrivateKey)serializable).publicKey(eCPublicKey);
    }

    @Override
    public <A extends PublicKey, B extends PrivateKey> PrivateJwkBuilder<B, A, ?, ?, ?> keyPair(KeyPair serializable) throws UnsupportedKeyException {
        PublicKey publicKey = KeyPairs.getKey(serializable, PublicKey.class);
        serializable = KeyPairs.getKey(serializable, PrivateKey.class);
        return this.key(serializable).publicKey(publicKey);
    }

    @Override
    public J build() {
        if (Strings.hasText(((JwkContext)this.DELEGATE).get(AbstractJwk.KTY))) {
            DefaultDynamicJwkBuilder defaultDynamicJwkBuilder = this;
            defaultDynamicJwkBuilder.setDelegate(defaultDynamicJwkBuilder.jwkFactory.newContext((JwkContext)this.DELEGATE, ((JwkContext)this.DELEGATE).getKey()));
        }
        return (J)super.build();
    }
}

