/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.HashAlgorithm;
import io.jsonwebtoken.security.JwkThumbprint;
import java.net.URI;
import java.security.MessageDigest;

class DefaultJwkThumbprint
implements JwkThumbprint {
    private static final String URI_PREFIX = "urn:ietf:params:oauth:jwk-thumbprint:";
    private final byte[] digest;
    private final HashAlgorithm alg;
    private final URI uri;
    private final int hashcode;
    private final String sval;

    DefaultJwkThumbprint(byte[] byArray, HashAlgorithm object) {
        this.digest = Assert.notEmpty(byArray, "Thumbprint digest byte array cannot be null or empty.");
        this.alg = Assert.notNull(object, "Thumbprint HashAlgorithm cannot be null.");
        object = Assert.hasText(Strings.clean(object.getId()), "Thumbprint HashAlgorithm id cannot be null or empty.");
        String string = Encoders.BASE64URL.encode(byArray);
        object = URI_PREFIX + (String)object + ":" + string;
        this.uri = URI.create((String)object);
        this.hashcode = Objects.nullSafeHashCode(this.digest, this.alg);
        this.sval = Encoders.BASE64URL.encode(byArray);
    }

    @Override
    public HashAlgorithm getHashAlgorithm() {
        return this.alg;
    }

    @Override
    public byte[] toByteArray() {
        return (byte[])this.digest.clone();
    }

    @Override
    public URI toURI() {
        return this.uri;
    }

    @Override
    public String toString() {
        return this.sval;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultJwkThumbprint) {
            object = (DefaultJwkThumbprint)object;
            return this.alg.equals(((DefaultJwkThumbprint)object).alg) && MessageDigest.isEqual(this.digest, ((DefaultJwkThumbprint)object).digest);
        }
        return false;
    }
}

