/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.security.KeyOperation;
import io.jsonwebtoken.security.KeyOperationPolicy;
import java.util.Collection;
import java.util.Iterator;

final class DefaultKeyOperationPolicy
implements KeyOperationPolicy {
    private final Collection<KeyOperation> ops;
    private final boolean allowUnrelated;

    DefaultKeyOperationPolicy(Collection<KeyOperation> collection, boolean bl2) {
        Assert.notEmpty(collection, "KeyOperation collection cannot be null or empty.");
        this.ops = Collections.immutable(collection);
        this.allowUnrelated = bl2;
    }

    @Override
    public final Collection<KeyOperation> getOperations() {
        return this.ops;
    }

    @Override
    public final void validate(Collection<? extends KeyOperation> object) {
        if (this.allowUnrelated || Collections.isEmpty(object)) {
            return;
        }
        Iterator<? extends KeyOperation> iterator = object.iterator();
        while (iterator.hasNext()) {
            KeyOperation keyOperation = iterator.next();
            Iterator<? extends KeyOperation> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                KeyOperation keyOperation2 = iterator2.next();
                if (keyOperation.isRelated(keyOperation2)) continue;
                object = "Unrelated key operations are not allowed. KeyOperation [" + keyOperation2 + "] is unrelated to [" + keyOperation + "].";
                throw new IllegalArgumentException((String)object);
            }
        }
    }

    public final int hashCode() {
        int n2 = Boolean.valueOf(this.allowUnrelated).hashCode();
        KeyOperation[] keyOperationArray = this.ops.toArray(new KeyOperation[0]);
        n2 = n2 * 31 + Objects.nullSafeHashCode(keyOperationArray);
        return n2;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultKeyOperationPolicy)) {
            return false;
        }
        object = (DefaultKeyOperationPolicy)object;
        return this.allowUnrelated == ((DefaultKeyOperationPolicy)object).allowUnrelated && Collections.size(this.ops) == Collections.size(((DefaultKeyOperationPolicy)object).ops) && this.ops.containsAll(((DefaultKeyOperationPolicy)object).ops);
    }
}

