/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.impl.lang.Parameters;
import io.jsonwebtoken.impl.security.AbstractPrivateJwk;
import io.jsonwebtoken.impl.security.DefaultRsaPublicJwk;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.RSAOtherPrimeInfoConverter;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.security.PrivateJwk;
import io.jsonwebtoken.security.RsaPrivateJwk;
import io.jsonwebtoken.security.RsaPublicJwk;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAOtherPrimeInfo;
import java.util.List;
import java.util.Set;

class DefaultRsaPrivateJwk
extends AbstractPrivateJwk<RSAPrivateKey, RSAPublicKey, RsaPublicJwk>
implements RsaPrivateJwk {
    static final Parameter<BigInteger> PRIVATE_EXPONENT = Parameters.secretBigInt("d", "Private Exponent");
    static final Parameter<BigInteger> FIRST_PRIME = Parameters.secretBigInt("p", "First Prime Factor");
    static final Parameter<BigInteger> SECOND_PRIME = Parameters.secretBigInt("q", "Second Prime Factor");
    static final Parameter<BigInteger> FIRST_CRT_EXPONENT = Parameters.secretBigInt("dp", "First Factor CRT Exponent");
    static final Parameter<BigInteger> SECOND_CRT_EXPONENT = Parameters.secretBigInt("dq", "Second Factor CRT Exponent");
    static final Parameter<BigInteger> FIRST_CRT_COEFFICIENT = Parameters.secretBigInt("qi", "First CRT Coefficient");
    static final Parameter<List<RSAOtherPrimeInfo>> OTHER_PRIMES_INFO = (Parameter)Parameters.builder(RSAOtherPrimeInfo.class).setId("oth").setName("Other Primes Info").setConverter(RSAOtherPrimeInfoConverter.INSTANCE).list().build();
    static final Set<Parameter<?>> PARAMS = Collections.concat(DefaultRsaPublicJwk.PARAMS, PRIVATE_EXPONENT, FIRST_PRIME, SECOND_PRIME, FIRST_CRT_EXPONENT, SECOND_CRT_EXPONENT, FIRST_CRT_COEFFICIENT, OTHER_PRIMES_INFO);

    DefaultRsaPrivateJwk(JwkContext<RSAPrivateKey> jwkContext, RsaPublicJwk rsaPublicJwk) {
        super(jwkContext, DefaultRsaPublicJwk.THUMBPRINT_PARAMS, rsaPublicJwk);
    }

    private static boolean equals(RSAOtherPrimeInfo rSAOtherPrimeInfo, RSAOtherPrimeInfo rSAOtherPrimeInfo2) {
        if (rSAOtherPrimeInfo == rSAOtherPrimeInfo2) {
            return true;
        }
        if (rSAOtherPrimeInfo == null || rSAOtherPrimeInfo2 == null) {
            return false;
        }
        return Parameters.bytesEquals(rSAOtherPrimeInfo.getPrime(), rSAOtherPrimeInfo2.getPrime()) && Parameters.bytesEquals(rSAOtherPrimeInfo.getExponent(), rSAOtherPrimeInfo2.getExponent()) && Parameters.bytesEquals(rSAOtherPrimeInfo.getCrtCoefficient(), rSAOtherPrimeInfo2.getCrtCoefficient());
    }

    private static boolean equalsOtherPrimes(ParameterReadable rSAOtherPrimeInfoArray, ParameterReadable rSAOtherPrimeInfoArray2) {
        int n2;
        rSAOtherPrimeInfoArray = rSAOtherPrimeInfoArray.get(OTHER_PRIMES_INFO);
        rSAOtherPrimeInfoArray2 = rSAOtherPrimeInfoArray2.get(OTHER_PRIMES_INFO);
        int n3 = Collections.size(rSAOtherPrimeInfoArray);
        if (n3 != (n2 = Collections.size(rSAOtherPrimeInfoArray2))) {
            return false;
        }
        if (n3 == 0) {
            return true;
        }
        rSAOtherPrimeInfoArray = rSAOtherPrimeInfoArray.toArray(new RSAOtherPrimeInfo[0]);
        rSAOtherPrimeInfoArray2 = rSAOtherPrimeInfoArray2.toArray(new RSAOtherPrimeInfo[0]);
        for (n2 = 0; n2 < n3; ++n2) {
            if (DefaultRsaPrivateJwk.equals(rSAOtherPrimeInfoArray[n2], rSAOtherPrimeInfoArray2[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean equals(PrivateJwk<?, ?, ?> privateJwk) {
        return privateJwk instanceof RsaPrivateJwk && DefaultRsaPublicJwk.equalsPublic(this, privateJwk) && Parameters.equals(this, privateJwk, PRIVATE_EXPONENT) && Parameters.equals(this, privateJwk, FIRST_PRIME) && Parameters.equals(this, privateJwk, SECOND_PRIME) && Parameters.equals(this, privateJwk, FIRST_CRT_EXPONENT) && Parameters.equals(this, privateJwk, SECOND_CRT_EXPONENT) && Parameters.equals(this, privateJwk, FIRST_CRT_COEFFICIENT) && DefaultRsaPrivateJwk.equalsOtherPrimes(this, (ParameterReadable)((Object)privateJwk));
    }
}

