/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.AbstractCurve;
import io.jsonwebtoken.impl.security.DefaultKeyPairBuilder;
import io.jsonwebtoken.impl.security.ECCurve$1;
import io.jsonwebtoken.impl.security.JcaTemplate;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.security.KeyPairBuilder;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ECCurve
extends AbstractCurve {
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    static final String KEY_PAIR_GENERATOR_JCA_NAME = "EC";
    public static final ECCurve P256 = new ECCurve("P-256", "secp256r1");
    public static final ECCurve P384 = new ECCurve("P-384", "secp384r1");
    public static final ECCurve P521 = new ECCurve("P-521", "secp521r1");
    public static final Collection<ECCurve> VALUES = Collections.setOf(P256, P384, P521);
    private static final Map<String, ECCurve> BY_ID = new LinkedHashMap<String, ECCurve>(3);
    private static final Map<EllipticCurve, ECCurve> BY_JCA_CURVE = new LinkedHashMap<EllipticCurve, ECCurve>(3);
    private final ECParameterSpec spec;

    static EllipticCurve assertJcaCurve(ECKey object) {
        Assert.notNull(object, "ECKey cannot be null.");
        object = Assert.notNull(object.getParams(), "ECKey params() cannot be null.");
        return Assert.notNull(((ECParameterSpec)object).getCurve(), "ECKey params().getCurve() cannot be null.");
    }

    static ECCurve findById(String string) {
        return BY_ID.get(string);
    }

    static ECCurve findByJcaCurve(EllipticCurve ellipticCurve) {
        return BY_JCA_CURVE.get(ellipticCurve);
    }

    static ECCurve findByKey(Key object) {
        if (!(object instanceof ECKey)) {
            return null;
        }
        Object object2 = (ECKey)object;
        if ((object2 = object2.getParams()) == null) {
            return null;
        }
        object2 = ((ECParameterSpec)object2).getCurve();
        if ((object2 = BY_JCA_CURVE.get(object2)) != null && object instanceof ECPublicKey) {
            object = (ECPublicKey)object;
            if ((object = object.getW()) == null || !((ECCurve)object2).contains((ECPoint)object)) {
                object2 = null;
            }
        }
        return object2;
    }

    static ECPublicKeySpec publicKeySpec(ECPrivateKey object) throws IllegalArgumentException {
        Object object2 = ECCurve.assertJcaCurve((ECKey)object);
        object2 = BY_JCA_CURVE.get(object2);
        Assert.notNull(object2, "There is no JWA-standard Elliptic Curve for specified ECPrivateKey.");
        object = super.multiply(object.getS());
        return new ECPublicKeySpec((ECPoint)object, ((ECCurve)object2).spec);
    }

    public ECCurve(String object, String string) {
        super((String)object, string);
        object = new JcaTemplate(KEY_PAIR_GENERATOR_JCA_NAME);
        this.spec = ((JcaTemplate)object).withAlgorithmParameters(new ECCurve$1(this));
    }

    public ECParameterSpec toParameterSpec() {
        return this.spec;
    }

    @Override
    public KeyPairBuilder keyPair() {
        return new DefaultKeyPairBuilder(KEY_PAIR_GENERATOR_JCA_NAME, this.toParameterSpec());
    }

    @Override
    public boolean contains(Key key) {
        if (key instanceof ECPublicKey) {
            ECParameterSpec eCParameterSpec = (key = (ECPublicKey)key).getParams();
            return eCParameterSpec != null && this.spec.getCurve().equals(eCParameterSpec.getCurve()) && this.contains(key.getW());
        }
        return false;
    }

    boolean contains(ECPoint eCPoint) {
        return ECCurve.contains(this.spec.getCurve(), eCPoint);
    }

    static boolean contains(EllipticCurve object, ECPoint object2) {
        if (object2 == null || ECPoint.POINT_INFINITY.equals(object2)) {
            return false;
        }
        BigInteger bigInteger = ((EllipticCurve)object).getA();
        BigInteger bigInteger2 = ((EllipticCurve)object).getB();
        BigInteger bigInteger3 = ((ECPoint)object2).getAffineX();
        object2 = ((ECPoint)object2).getAffineY();
        object = ((ECFieldFp)((EllipticCurve)object).getField()).getP();
        if (bigInteger3.compareTo(BigInteger.ZERO) < 0 || bigInteger3.compareTo((BigInteger)object) >= 0 || ((BigInteger)object2).compareTo(BigInteger.ZERO) < 0 || ((BigInteger)object2).compareTo((BigInteger)object) >= 0) {
            return false;
        }
        object2 = ((BigInteger)object2).modPow(TWO, (BigInteger)object);
        object = bigInteger3.modPow(THREE, (BigInteger)object).add(bigInteger.multiply(bigInteger3)).add(bigInteger2).mod((BigInteger)object);
        return ((BigInteger)object2).equals(object);
    }

    private ECPoint multiply(BigInteger bigInteger) {
        ECCurve eCCurve = this;
        return eCCurve.multiply(eCCurve.spec.getGenerator(), bigInteger);
    }

    private ECPoint multiply(ECPoint eCPoint, BigInteger bigInteger) {
        if (ECPoint.POINT_INFINITY.equals(eCPoint)) {
            return eCPoint;
        }
        Object object = this.spec.getOrder();
        bigInteger = bigInteger.mod((BigInteger)object);
        object = ECPoint.POINT_INFINITY;
        for (int i2 = bigInteger.bitLength() - 1; i2 >= 0; --i2) {
            if (bigInteger.testBit(i2)) {
                object = this.add((ECPoint)object, eCPoint);
                eCPoint = this.doublePoint(eCPoint);
                continue;
            }
            eCPoint = this.add((ECPoint)object, eCPoint);
            object = this.doublePoint((ECPoint)object);
        }
        return object;
    }

    private ECPoint add(ECPoint object, ECPoint object2) {
        if (ECPoint.POINT_INFINITY.equals(object)) {
            return object2;
        }
        if (ECPoint.POINT_INFINITY.equals(object2)) {
            return object;
        }
        if (((ECPoint)object).equals(object2)) {
            return this.doublePoint((ECPoint)object);
        }
        Object object3 = this.spec.getCurve();
        BigInteger bigInteger = ((ECPoint)object).getAffineX();
        object = ((ECPoint)object).getAffineY();
        BigInteger bigInteger2 = ((ECPoint)object2).getAffineX();
        object2 = ((ECPoint)object2).getAffineY();
        object3 = ((ECFieldFp)((EllipticCurve)object3).getField()).getP();
        object2 = ((BigInteger)object2).subtract((BigInteger)object).multiply(bigInteger2.subtract(bigInteger).modInverse((BigInteger)object3)).mod((BigInteger)object3);
        bigInteger2 = ((BigInteger)object2).pow(2).subtract(bigInteger).subtract(bigInteger2).mod((BigInteger)object3);
        object = ((BigInteger)object2).multiply(bigInteger.subtract(bigInteger2)).subtract((BigInteger)object).mod((BigInteger)object3);
        return new ECPoint(bigInteger2, (BigInteger)object);
    }

    private ECPoint doublePoint(ECPoint object) {
        if (ECPoint.POINT_INFINITY.equals(object)) {
            return object;
        }
        Object object2 = this.spec.getCurve();
        BigInteger bigInteger = ((ECPoint)object).getAffineX();
        object = ((ECPoint)object).getAffineY();
        BigInteger bigInteger2 = ((ECFieldFp)((EllipticCurve)object2).getField()).getP();
        object2 = ((EllipticCurve)object2).getA();
        object2 = THREE.multiply(bigInteger.pow(2)).add((BigInteger)object2).mod(bigInteger2).multiply(TWO.multiply((BigInteger)object).modInverse(bigInteger2)).mod(bigInteger2);
        BigInteger bigInteger3 = ((BigInteger)object2).pow(2).subtract(TWO.multiply(bigInteger)).mod(bigInteger2);
        object = ((BigInteger)object2).multiply(bigInteger.subtract(bigInteger3)).subtract((BigInteger)object).mod(bigInteger2);
        return new ECPoint(bigInteger3, (BigInteger)object);
    }

    static {
        for (ECCurve eCCurve : VALUES) {
            BY_ID.put(eCCurve.getId(), eCCurve);
        }
        for (ECCurve eCCurve : VALUES) {
            BY_JCA_CURVE.put(eCCurve.spec.getCurve(), eCCurve);
        }
    }
}

