/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.AbstractEcJwkFactory;
import io.jsonwebtoken.impl.security.DefaultEcPrivateJwk;
import io.jsonwebtoken.impl.security.DefaultEcPublicJwk;
import io.jsonwebtoken.impl.security.DefaultJwkContext;
import io.jsonwebtoken.impl.security.ECCurve;
import io.jsonwebtoken.impl.security.EcPrivateJwkFactory$1;
import io.jsonwebtoken.impl.security.EcPrivateJwkFactory$2;
import io.jsonwebtoken.impl.security.EcPublicJwkFactory;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.EcPrivateJwk;
import io.jsonwebtoken.security.EcPublicJwk;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;

class EcPrivateJwkFactory
extends AbstractEcJwkFactory<ECPrivateKey, EcPrivateJwk> {
    private static final String ECPUBKEY_ERR_MSG = "JwkContext publicKey must be an " + ECPublicKey.class.getName() + " instance.";
    private static final EcPublicJwkFactory PUB_FACTORY = EcPublicJwkFactory.INSTANCE;

    EcPrivateJwkFactory() {
        super(ECPrivateKey.class, DefaultEcPrivateJwk.PARAMS);
    }

    @Override
    protected boolean supportsKeyValues(JwkContext<?> jwkContext) {
        return super.supportsKeyValues(jwkContext) && jwkContext.containsKey(DefaultEcPrivateJwk.D.getId());
    }

    protected ECPublicKey derivePublic(KeyFactory keyFactory, ECPublicKeySpec eCPublicKeySpec) throws InvalidKeySpecException {
        return (ECPublicKey)keyFactory.generatePublic(eCPublicKeySpec);
    }

    protected ECPublicKey derivePublic(JwkContext<ECPrivateKey> jwkContext) {
        ECPrivateKey eCPrivateKey = jwkContext.getKey();
        return this.generateKey(jwkContext, ECPublicKey.class, new EcPrivateJwkFactory$1(this, eCPrivateKey));
    }

    @Override
    protected EcPrivateJwk createJwkFromKey(JwkContext<ECPrivateKey> jwkContext) {
        Object object = jwkContext.getKey();
        Object object2 = jwkContext.getPublicKey();
        object2 = object2 != null ? Assert.isInstanceOf(ECPublicKey.class, object2, ECPUBKEY_ERR_MSG) : this.derivePublic(jwkContext);
        boolean bl2 = !Strings.hasText(jwkContext.getId()) && jwkContext.getIdThumbprintAlgorithm() != null;
        object2 = PUB_FACTORY.newContext(jwkContext, object2);
        object2 = (EcPublicJwk)PUB_FACTORY.createJwk(object2);
        jwkContext.putAll(object2);
        if (bl2) {
            jwkContext.setId(object2.getId());
        }
        object = EcPrivateJwkFactory.toOctetString(object.getParams().getCurve(), object.getS());
        jwkContext.put((ECPrivateKey)((Object)DefaultEcPrivateJwk.D.getId()), object);
        return new DefaultEcPrivateJwk(jwkContext, (EcPublicJwk)object2);
    }

    @Override
    protected EcPrivateJwk createJwkFromValues(JwkContext<ECPrivateKey> jwkContext) {
        Object object = new RequiredParameterReader(jwkContext);
        Object object2 = object.get(DefaultEcPublicJwk.CRV);
        object = object.get(DefaultEcPrivateJwk.D);
        Map<String, Object> map = new DefaultJwkContext(DefaultEcPublicJwk.PARAMS, jwkContext);
        map = (EcPublicJwk)EcPublicJwkFactory.INSTANCE.createJwk(map);
        object2 = EcPrivateJwkFactory.getCurveByJwaId((String)object2);
        object = new ECPrivateKeySpec((BigInteger)object, ((ECCurve)object2).toParameterSpec());
        object = this.generateKey(jwkContext, new EcPrivateJwkFactory$2(this, (ECPrivateKeySpec)object));
        jwkContext.setKey((ECPrivateKey)object);
        return new DefaultEcPrivateJwk(jwkContext, (EcPublicJwk)map);
    }
}

