/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.impl.DefaultJweHeader;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.AbstractCurve;
import io.jsonwebtoken.impl.security.ConcatKDF;
import io.jsonwebtoken.impl.security.CryptoAlgorithm;
import io.jsonwebtoken.impl.security.DefaultDecryptionKeyRequest;
import io.jsonwebtoken.impl.security.DefaultKeyRequest;
import io.jsonwebtoken.impl.security.DirectKeyAlgorithm;
import io.jsonwebtoken.impl.security.ECCurve;
import io.jsonwebtoken.impl.security.EcdhKeyAlgorithm$1;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.impl.security.StandardCurves;
import io.jsonwebtoken.lang.Arrays;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.AeadAlgorithm;
import io.jsonwebtoken.security.Curve;
import io.jsonwebtoken.security.DecryptionKeyRequest;
import io.jsonwebtoken.security.DynamicJwkBuilder;
import io.jsonwebtoken.security.EcPublicJwk;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.Jwks;
import io.jsonwebtoken.security.KeyAlgorithm;
import io.jsonwebtoken.security.KeyLengthSupplier;
import io.jsonwebtoken.security.KeyPairBuilder;
import io.jsonwebtoken.security.KeyRequest;
import io.jsonwebtoken.security.KeyResult;
import io.jsonwebtoken.security.OctetPublicJwk;
import io.jsonwebtoken.security.PublicJwk;
import io.jsonwebtoken.security.Request;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SecurityException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECKey;
import javax.crypto.SecretKey;

class EcdhKeyAlgorithm
extends CryptoAlgorithm
implements KeyAlgorithm<PublicKey, PrivateKey> {
    protected static final String JCA_NAME = "ECDH";
    protected static final String XDH_JCA_NAME = "XDH";
    protected static final String DEFAULT_ID = "ECDH-ES";
    private static final String CONCAT_KDF_HASH_ALG_NAME = "SHA-256";
    private static final ConcatKDF CONCAT_KDF = new ConcatKDF("SHA-256");
    private final KeyAlgorithm<SecretKey, SecretKey> WRAP_ALG;

    private static String idFor(KeyAlgorithm<SecretKey, SecretKey> keyAlgorithm) {
        if (keyAlgorithm instanceof DirectKeyAlgorithm) {
            return DEFAULT_ID;
        }
        return "ECDH-ES+" + keyAlgorithm.getId();
    }

    EcdhKeyAlgorithm() {
        this(new DirectKeyAlgorithm());
    }

    EcdhKeyAlgorithm(KeyAlgorithm<SecretKey, SecretKey> keyAlgorithm) {
        super(EcdhKeyAlgorithm.idFor(keyAlgorithm), JCA_NAME);
        this.WRAP_ALG = Assert.notNull(keyAlgorithm, "Wrap algorithm cannot be null.");
    }

    protected KeyPair generateKeyPair(Curve curve, Provider provider, SecureRandom secureRandom) {
        return (KeyPair)((KeyPairBuilder)((KeyPairBuilder)curve.keyPair().provider(provider)).random(secureRandom)).build();
    }

    protected byte[] generateZ(KeyRequest<?> keyRequest, PublicKey publicKey, PrivateKey privateKey) {
        return this.jca(keyRequest).withKeyAgreement(new EcdhKeyAlgorithm$1(this, privateKey, keyRequest, publicKey));
    }

    protected String getConcatKDFAlgorithmId(AeadAlgorithm aeadAlgorithm) {
        if (this.WRAP_ALG instanceof DirectKeyAlgorithm) {
            return Assert.hasText(aeadAlgorithm.getId(), "AeadAlgorithm id cannot be null or empty.");
        }
        return this.getId();
    }

    private byte[] createOtherInfo(int n2, String object, byte[] byArray, byte[] byArray2) {
        Assert.hasText(object, "AlgorithmId cannot be null or empty.");
        object = ((String)object).getBytes(StandardCharsets.US_ASCII);
        byArray = Arrays.length(byArray) == 0 ? Bytes.EMPTY : byArray;
        byArray2 = Arrays.length(byArray2) == 0 ? Bytes.EMPTY : byArray2;
        return Bytes.concat(Bytes.toBytes(((Object)object).length), (byte[])object, Bytes.toBytes(byArray.length), byArray, Bytes.toBytes(byArray2.length), byArray2, Bytes.toBytes(n2), Bytes.EMPTY);
    }

    private int getKeyBitLength(AeadAlgorithm aeadAlgorithm) {
        int n2 = this.WRAP_ALG instanceof KeyLengthSupplier ? ((KeyLengthSupplier)((Object)this.WRAP_ALG)).getKeyBitLength() : aeadAlgorithm.getKeyBitLength();
        return Assert.gt(n2, 0, "Algorithm keyBitLength must be > 0");
    }

    private SecretKey deriveKey(KeyRequest<?> object, PublicKey key, PrivateKey privateKey) {
        Object object2 = Assert.notNull(object.getEncryptionAlgorithm(), "Request encryptionAlgorithm cannot be null.");
        int n2 = this.getKeyBitLength((AeadAlgorithm)object2);
        object2 = this.getConcatKDFAlgorithmId((AeadAlgorithm)object2);
        byte[] byArray = object.getHeader().getAgreementPartyUInfo();
        byte[] byArray2 = object.getHeader().getAgreementPartyVInfo();
        object2 = this.createOtherInfo(n2, (String)object2, byArray, byArray2);
        object = this.generateZ((KeyRequest<?>)object, (PublicKey)key, privateKey);
        try {
            key = CONCAT_KDF.deriveKey((byte[])object, n2, (byte[])object2);
            return key;
        }
        finally {
            Bytes.clear((byte[])object);
        }
    }

    @Override
    protected String getJcaName(Request<?> request) {
        if (request instanceof SecureRequest) {
            if (((SecureRequest)request).getKey() instanceof ECKey) {
                return super.getJcaName(request);
            }
            return XDH_JCA_NAME;
        }
        if (request.getPayload() instanceof ECKey) {
            return super.getJcaName(request);
        }
        return XDH_JCA_NAME;
    }

    private static AbstractCurve assertCurve(Key object) {
        Object object2 = StandardCurves.findByKey((Key)object);
        if (object2 == null) {
            object2 = object instanceof PublicKey ? "encryption " : "decryption ";
            object = "Unable to determine JWA-standard Elliptic Curve for " + (String)object2 + "key [" + KeysBridge.toString((Key)object) + "]";
            throw new InvalidKeyException((String)object);
        }
        if (object2 instanceof EdwardsCurve && ((EdwardsCurve)object2).isSignatureCurve()) {
            object2 = object2.getId() + " keys may not be used with ECDH-ES key agreement algorithms per https://www.rfc-editor.org/rfc/rfc8037#section-3.1.";
            throw new InvalidKeyException((String)object2);
        }
        return Assert.isInstanceOf(AbstractCurve.class, object2, "AbstractCurve instance expected.");
    }

    @Override
    public KeyResult getEncryptionKey(KeyRequest<PublicKey> message) throws SecurityException {
        Assert.notNull(message, "Request cannot be null.");
        JweHeader jweHeader = Assert.notNull(message.getHeader(), "Request JweHeader cannot be null.");
        Key key = (PublicKey)Assert.notNull(message.getPayload(), "Encryption PublicKey cannot be null.");
        Object object = EcdhKeyAlgorithm.assertCurve(key);
        Assert.stateNotNull(object, "Internal implementation state: Curve cannot be null.");
        Object object2 = EcdhKeyAlgorithm.ensureSecureRandom(message);
        DynamicJwkBuilder dynamicJwkBuilder = (DynamicJwkBuilder)Jwks.builder().random((SecureRandom)object2);
        object = this.generateKeyPair((Curve)object, null, (SecureRandom)object2);
        Assert.stateNotNull(object, "Internal implementation state: KeyPair cannot be null.");
        object2 = (PublicJwk)dynamicJwkBuilder.key(((KeyPair)object).getPublic()).build();
        key = this.deriveKey((KeyRequest<?>)message, (PublicKey)key, ((KeyPair)object).getPrivate());
        message = new DefaultKeyRequest<PublicKey>((PublicKey)key, message.getProvider(), message.getSecureRandom(), message.getHeader(), message.getEncryptionAlgorithm());
        message = this.WRAP_ALG.getEncryptionKey((KeyRequest<SecretKey>)message);
        jweHeader.put(DefaultJweHeader.EPK.getId(), object2);
        return message;
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<PrivateKey> decryptionKeyRequest) throws SecurityException {
        Assert.notNull(decryptionKeyRequest, "Request cannot be null.");
        JweHeader jweHeader = Assert.notNull(decryptionKeyRequest.getHeader(), "Request JweHeader cannot be null.");
        Object object = (PrivateKey)Assert.notNull(decryptionKeyRequest.getKey(), "Decryption PrivateKey cannot be null.");
        Object object2 = new RequiredParameterReader(jweHeader);
        object2 = object2.get(DefaultJweHeader.EPK);
        AbstractCurve abstractCurve = EcdhKeyAlgorithm.assertCurve((Key)object);
        Assert.stateNotNull(abstractCurve, "Internal implementation state: Curve cannot be null.");
        Class clazz = abstractCurve instanceof ECCurve ? EcPublicJwk.class : OctetPublicJwk.class;
        if (!clazz.isInstance(object2)) {
            object = "JWE Header " + DefaultJweHeader.EPK + " value is not an Elliptic Curve Public JWK. Value: " + object2;
            throw new InvalidKeyException((String)object);
        }
        if (!abstractCurve.contains((Key)object2.toKey())) {
            object = "JWE Header " + DefaultJweHeader.EPK + " value does not represent a point on the expected curve. Value: " + object2;
            throw new InvalidKeyException((String)object);
        }
        object = this.deriveKey(decryptionKeyRequest, (PublicKey)object2.toKey(), (PrivateKey)object);
        decryptionKeyRequest = new DefaultDecryptionKeyRequest<Object>((byte[])decryptionKeyRequest.getPayload(), null, decryptionKeyRequest.getSecureRandom(), jweHeader, decryptionKeyRequest.getEncryptionAlgorithm(), object);
        return this.WRAP_ALG.getDecryptionKey(decryptionKeyRequest);
    }
}

