/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.AbstractSignatureAlgorithm;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeyPairBuilder;
import io.jsonwebtoken.security.Request;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.VerifyDigestRequest;
import java.security.Key;
import java.security.PrivateKey;

final class EdSignatureAlgorithm
extends AbstractSignatureAlgorithm {
    private static final String ID = "EdDSA";
    private final EdwardsCurve preferredCurve = EdwardsCurve.Ed448;
    static final EdSignatureAlgorithm INSTANCE = new EdSignatureAlgorithm();

    static boolean isSigningKey(PrivateKey object) {
        return (object = EdwardsCurve.findByKey((Key)object)) != null && ((EdwardsCurve)object).isSignatureCurve();
    }

    private EdSignatureAlgorithm() {
        super(ID, ID);
        Assert.isTrue(this.preferredCurve.isSignatureCurve(), "Must be signature curve, not key agreement curve.");
    }

    @Override
    protected final String getJcaName(Request<?> request) {
        Object object = Assert.isInstanceOf(SecureRequest.class, request, "SecureRequests are required.");
        object = (Key)Assert.notNull(object.getKey(), "Request key cannot be null.");
        String string = this.getJcaName();
        if (!(request instanceof VerifyDigestRequest)) {
            string = EdwardsCurve.forKey((Key)object).getJcaName();
        }
        return string;
    }

    @Override
    public final KeyPairBuilder keyPair() {
        return this.preferredCurve.keyPair();
    }

    @Override
    protected final void validateKey(Key object, boolean bl2) {
        super.validateKey((Key)object, bl2);
        object = EdwardsCurve.forKey((Key)object);
        if (!((EdwardsCurve)object).isSignatureCurve()) {
            object = ((EdwardsCurve)object).getId() + " keys may not be used with " + this.getId() + " digital signatures per https://www.rfc-editor.org/rfc/rfc8037.html#section-3.2";
            throw new InvalidKeyException((String)object);
        }
    }
}

