/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.security.AbstractCurve;
import io.jsonwebtoken.impl.security.DefaultKeyPairBuilder;
import io.jsonwebtoken.impl.security.EdwardsPublicKeyDeriver;
import io.jsonwebtoken.impl.security.JcaTemplate;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.impl.security.NamedParameterSpecValueFinder;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeyException;
import io.jsonwebtoken.security.KeyLengthSupplier;
import io.jsonwebtoken.security.KeyPairBuilder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class EdwardsCurve
extends AbstractCurve
implements KeyLengthSupplier {
    private static final String OID_PREFIX = "1.3.101.";
    private static final byte[] ASN1_OID_PREFIX = new byte[]{6, 3, 43, 101};
    private static final Function<Key, String> CURVE_NAME_FINDER = new NamedParameterSpecValueFinder();
    public static final EdwardsCurve X25519 = new EdwardsCurve("X25519", 110);
    public static final EdwardsCurve X448 = new EdwardsCurve("X448", 111);
    public static final EdwardsCurve Ed25519 = new EdwardsCurve("Ed25519", 112);
    public static final EdwardsCurve Ed448 = new EdwardsCurve("Ed448", 113);
    public static final Collection<EdwardsCurve> VALUES = Collections.of(X25519, X448, Ed25519, Ed448);
    private static final Map<String, EdwardsCurve> REGISTRY = new LinkedHashMap<String, EdwardsCurve>(8);
    private static final Map<Integer, EdwardsCurve> BY_OID_TERMINAL_NODE = new LinkedHashMap<Integer, EdwardsCurve>(4);
    private final String OID;
    final byte[] ASN1_OID;
    private final int keyBitLength;
    private final int encodedKeyByteLength;
    private final byte[] PUBLIC_KEY_ASN1_PREFIX;
    private final byte[] PRIVATE_KEY_ASN1_PREFIX;
    private final byte[] PRIVATE_KEY_JDK11_PREFIX;
    private final boolean signatureCurve;

    private static byte[] publicKeyAsn1Prefix(int n2, byte[] byArray) {
        return Bytes.concat({48, (byte)(n2 + 10), 48, 5}, byArray, {3, (byte)(n2 + 1), 0});
    }

    private static byte[] privateKeyPkcs8Prefix(int n2, byte[] byArray, boolean bl2) {
        byte[] byArray2;
        if (bl2) {
            byte[] byArray3 = new byte[4];
            byArray3[0] = 4;
            byArray3[1] = (byte)(n2 + 2);
            byArray3[2] = 4;
            byArray2 = byArray3;
            byArray3[3] = (byte)n2;
        } else {
            byte[] byArray4 = new byte[2];
            byArray4[0] = 4;
            byArray2 = byArray4;
            byArray4[1] = (byte)n2;
        }
        byte[] byArray5 = byArray2;
        return Bytes.concat({48, (byte)(5 + byArray.length + byArray5.length + n2), 2, 1, 0, 48, 5}, byArray, byArray5);
    }

    EdwardsCurve(String string, int n2) {
        String string2 = string;
        super(string2, string2);
        if (n2 < 110 || n2 > 113) {
            string = "Invalid Edwards Curve ASN.1 OID terminal node value";
            throw new IllegalArgumentException(string);
        }
        this.keyBitLength = n2 % 2 == 0 ? 255 : 448;
        int n3 = n2 == 113 ? this.keyBitLength + 8 : this.keyBitLength;
        this.encodedKeyByteLength = Bytes.length(n3);
        this.OID = OID_PREFIX + n2;
        this.signatureCurve = n2 == 112 || n2 == 113;
        byte[] byArray = new byte[]{(byte)n2};
        this.ASN1_OID = Bytes.concat(ASN1_OID_PREFIX, byArray);
        this.PUBLIC_KEY_ASN1_PREFIX = EdwardsCurve.publicKeyAsn1Prefix(this.encodedKeyByteLength, this.ASN1_OID);
        this.PRIVATE_KEY_ASN1_PREFIX = EdwardsCurve.privateKeyPkcs8Prefix(this.encodedKeyByteLength, this.ASN1_OID, true);
        this.PRIVATE_KEY_JDK11_PREFIX = EdwardsCurve.privateKeyPkcs8Prefix(this.encodedKeyByteLength, this.ASN1_OID, false);
    }

    @Override
    public int getKeyBitLength() {
        return this.keyBitLength;
    }

    public byte[] getKeyMaterial(Key serializable) {
        try {
            return this.doGetKeyMaterial((Key)serializable);
        }
        catch (Throwable throwable) {
            serializable = throwable;
            if (throwable instanceof KeyException) {
                throw (KeyException)serializable;
            }
            String string = "Invalid " + this.getId() + " ASN.1 encoding: " + ((Throwable)serializable).getMessage();
            throw new InvalidKeyException(string, (Throwable)serializable);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] doGetKeyMaterial(Key object) {
        void var3_8;
        Object object2;
        byte[] byArray = KeysBridge.getEncoded((Key)object);
        object = byArray;
        int n2 = Bytes.indexOf(byArray, this.ASN1_OID);
        Assert.gt(n2, -1, "Missing or incorrect algorithm OID.");
        boolean n3 = false;
        if (object[n2 += this.ASN1_OID.length] == 5) {
            object2 = object[++n2];
            Assert.eq((int)object2, 0, "OID NULL terminator should indicate zero unused bytes.");
            ++n2;
        }
        if (object[n2] == 3) {
            void var3_5;
            int n4 = ++n2;
            Object object3 = object[n4];
            int n5 = ++n2;
            object2 = object[n5];
            Assert.eq((int)object2, 0, "BIT STREAM should not indicate unused bytes.");
            --var3_5;
        } else if (object[n2] == 4) {
            int n6 = ++n2;
            Object object4 = object[n6];
            if (object[++n2] == 4) {
                int n7 = ++n2;
                ++n2;
                Object object5 = object[n7];
            }
        }
        Assert.eq((int)var3_8, this.encodedKeyByteLength, "Invalid key length.");
        int n8 = ++n2;
        byte[] byArray2 = Arrays.copyOfRange((byte[])object, n8, n8 + var3_8);
        int n9 = Bytes.length(byArray2);
        Assert.eq(n9, this.encodedKeyByteLength, "Invalid key length.");
        return byArray2;
    }

    private void assertLength(byte[] byArray, boolean bl2) {
        int n2 = Bytes.length(byArray);
        if (n2 != this.encodedKeyByteLength) {
            String string = "Invalid " + this.getId() + " encoded " + (bl2 ? "PublicKey" : "PrivateKey") + " length. Should be " + Bytes.bytesMsg(this.encodedKeyByteLength) + ", found " + Bytes.bytesMsg(n2) + ".";
            throw new InvalidKeyException(string);
        }
    }

    public PublicKey toPublicKey(byte[] object, Provider object2) {
        this.assertLength((byte[])object, true);
        object = Bytes.concat(new byte[][]{this.PUBLIC_KEY_ASN1_PREFIX, object});
        object = new X509EncodedKeySpec((byte[])object);
        object2 = new JcaTemplate(this.getJcaName(), (Provider)object2);
        return ((JcaTemplate)object2).generatePublic((KeySpec)object);
    }

    KeySpec privateKeySpec(byte[] byArray, boolean bl2) {
        byte[] byArray2 = bl2 ? this.PRIVATE_KEY_ASN1_PREFIX : this.PRIVATE_KEY_JDK11_PREFIX;
        byArray = Bytes.concat(byArray2, byArray);
        return new PKCS8EncodedKeySpec(byArray);
    }

    public PrivateKey toPrivateKey(byte[] object, Provider object2) {
        this.assertLength((byte[])object, false);
        object = this.privateKeySpec((byte[])object, true);
        object2 = new JcaTemplate(this.getJcaName(), (Provider)object2);
        return ((JcaTemplate)object2).generatePrivate((KeySpec)object);
    }

    public boolean isSignatureCurve() {
        return this.signatureCurve;
    }

    @Override
    public KeyPairBuilder keyPair() {
        return new DefaultKeyPairBuilder(this.getJcaName(), this.keyBitLength);
    }

    public static boolean isEdwards(Key key) {
        if (key == null) {
            return false;
        }
        String string = Strings.clean(key.getAlgorithm());
        return "EdDSA".equals(string) || "XDH".equals(string) || EdwardsCurve.findByKey(key) != null;
    }

    public static PublicKey derivePublic(PrivateKey privateKey) throws KeyException {
        return EdwardsPublicKeyDeriver.INSTANCE.apply(privateKey);
    }

    public static EdwardsCurve findById(String string) {
        return REGISTRY.get(string);
    }

    public static EdwardsCurve findByKey(Key key) {
        if (key == null) {
            return null;
        }
        Object object = key.getAlgorithm();
        if ((object = EdwardsCurve.findById((String)object)) == null) {
            object = CURVE_NAME_FINDER.apply(key);
            object = EdwardsCurve.findById((String)object);
        }
        byte[] byArray = KeysBridge.findEncoded(key);
        if (object == null && !Bytes.isEmpty(byArray)) {
            int n2 = EdwardsCurve.findOidTerminalNode(byArray);
            object = BY_OID_TERMINAL_NODE.get(n2);
        }
        if (object != null && !Bytes.isEmpty(byArray)) {
            try {
                ((EdwardsCurve)object).getKeyMaterial(key);
            }
            catch (Throwable throwable) {
                object = null;
            }
        }
        return object;
    }

    @Override
    public boolean contains(Key object) {
        object = EdwardsCurve.findByKey((Key)object);
        return ((EdwardsCurve)object).equals(this);
    }

    private static int findOidTerminalNode(byte[] byArray) {
        int n2 = Bytes.indexOf(byArray, ASN1_OID_PREFIX);
        if (n2 >= 0 && (n2 += ASN1_OID_PREFIX.length) < byArray.length) {
            return byArray[n2];
        }
        return -1;
    }

    public static EdwardsCurve forKey(Key object) {
        Assert.notNull(object, "Key cannot be null.");
        EdwardsCurve edwardsCurve = EdwardsCurve.findByKey((Key)object);
        if (edwardsCurve == null) {
            object = "Unrecognized Edwards Curve key: [" + KeysBridge.toString((Key)object) + "]";
            throw new InvalidKeyException((String)object);
        }
        return edwardsCurve;
    }

    static <K extends Key> K assertEdwards(K k2) {
        EdwardsCurve.forKey(k2);
        return k2;
    }

    static {
        for (EdwardsCurve edwardsCurve : VALUES) {
            byte by2 = edwardsCurve.ASN1_OID[edwardsCurve.ASN1_OID.length - 1];
            BY_OID_TERMINAL_NODE.put(Integer.valueOf(by2), edwardsCurve);
            REGISTRY.put(edwardsCurve.getId(), edwardsCurve);
            REGISTRY.put(edwardsCurve.OID, edwardsCurve);
        }
    }
}

