/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.impl.lang.Nameable;
import io.jsonwebtoken.impl.security.AbstractJwk;
import io.jsonwebtoken.impl.security.JwkBuilderSupplier;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.lang.Supplier;
import io.jsonwebtoken.security.DynamicJwkBuilder;
import io.jsonwebtoken.security.EcPrivateJwk;
import io.jsonwebtoken.security.EcPublicJwk;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.MalformedKeyException;
import io.jsonwebtoken.security.OctetPrivateJwk;
import io.jsonwebtoken.security.OctetPublicJwk;
import io.jsonwebtoken.security.PrivateJwk;
import io.jsonwebtoken.security.PublicJwk;
import io.jsonwebtoken.security.RsaPrivateJwk;
import io.jsonwebtoken.security.RsaPublicJwk;
import io.jsonwebtoken.security.SecretJwk;
import java.util.Map;

public final class JwkConverter<T extends Jwk<?>>
implements Converter<T, Object> {
    public static final Class<Jwk<?>> JWK_CLASS = Jwk.class;
    public static final Class<PublicJwk<?>> PUBLIC_JWK_CLASS = PublicJwk.class;
    public static final JwkConverter<Jwk<?>> ANY = new JwkConverter(JWK_CLASS);
    public static final JwkConverter<PublicJwk<?>> PUBLIC_JWK = new JwkConverter(PUBLIC_JWK_CLASS);
    private final Class<T> desiredType;
    private final Supplier<DynamicJwkBuilder<?, ?>> supplier;

    public JwkConverter(Class<T> clazz) {
        this(clazz, JwkBuilderSupplier.DEFAULT);
    }

    public JwkConverter(Supplier<DynamicJwkBuilder<?, ?>> supplier) {
        this(JWK_CLASS, supplier);
    }

    public JwkConverter(Class<T> clazz, Supplier<DynamicJwkBuilder<?, ?>> supplier) {
        this.desiredType = Assert.notNull(clazz, "desiredType cannot be null.");
        this.supplier = Assert.notNull(supplier, "supplier cannot be null.");
    }

    @Override
    public final Object applyTo(T t2) {
        return this.desiredType.cast(t2);
    }

    private static String articleFor(String string) {
        switch (string.charAt(0)) {
            case 'E': 
            case 'R': {
                return "an";
            }
        }
        return "a";
    }

    private static String typeString(Jwk<?> jwk) {
        Assert.isInstanceOf(Nameable.class, jwk, "All JWK implementations must implement Nameable.");
        return ((Nameable)((Object)jwk)).getName();
    }

    private static String typeString(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        if (SecretJwk.class.isAssignableFrom(clazz)) {
            stringBuilder.append("Secret");
        } else if (RsaPublicJwk.class.isAssignableFrom(clazz) || RsaPrivateJwk.class.isAssignableFrom(clazz)) {
            stringBuilder.append("RSA");
        } else if (EcPublicJwk.class.isAssignableFrom(clazz) || EcPrivateJwk.class.isAssignableFrom(clazz)) {
            stringBuilder.append("EC");
        } else if (OctetPublicJwk.class.isAssignableFrom(clazz) || OctetPrivateJwk.class.isAssignableFrom(clazz)) {
            stringBuilder.append("Edwards Curve");
        }
        return JwkConverter.typeString(stringBuilder, clazz);
    }

    private static String typeString(StringBuilder stringBuilder, Class<?> clazz) {
        if (PublicJwk.class.isAssignableFrom(clazz)) {
            Strings.nespace(stringBuilder).append("Public");
        } else if (PrivateJwk.class.isAssignableFrom(clazz)) {
            Strings.nespace(stringBuilder).append("Private");
        }
        Strings.nespace(stringBuilder).append("JWK");
        return stringBuilder.toString();
    }

    private IllegalArgumentException unexpectedIAE(Jwk<?> object) {
        String string = JwkConverter.typeString(this.desiredType);
        object = JwkConverter.typeString(object);
        object = "Value must be " + JwkConverter.articleFor(string) + " " + string + ", not " + JwkConverter.articleFor((String)object) + " " + (String)object + ".";
        return new IllegalArgumentException((String)object);
    }

    @Override
    public final T applyFrom(Object object) {
        Assert.notNull(object, "JWK cannot be null.");
        if (this.desiredType.isInstance(object)) {
            return (T)((Jwk)this.desiredType.cast(object));
        }
        if (object instanceof Jwk) {
            throw this.unexpectedIAE((Jwk)object);
        }
        if (!(object instanceof Map)) {
            object = "JWK must be a Map<String,?> (JSON Object). Type found: " + object.getClass().getName() + ".";
            throw new IllegalArgumentException((String)object);
        }
        object = Collections.immutable((Map)object);
        Object object2 = AbstractJwk.KTY;
        if (Collections.isEmpty(object) || !object.containsKey(object2.getId())) {
            String string = "JWK is missing required " + object2 + " parameter.";
            throw new MalformedKeyException(string);
        }
        Object object32 = object.get(object2.getId());
        if (object32 == null) {
            String string = "JWK " + object2 + " value cannot be null.";
            throw new MalformedKeyException(string);
        }
        if (!(object32 instanceof String)) {
            String string = "JWK " + object2 + " value must be a String. Type found: " + object32.getClass().getName();
            throw new MalformedKeyException(string);
        }
        String string = (String)object32;
        if (!Strings.hasText(string)) {
            object2 = "JWK " + object2 + " value cannot be empty.";
            throw new MalformedKeyException((String)object2);
        }
        object2 = this.supplier.get();
        for (Map.Entry entry : object.entrySet()) {
            Object object3 = entry.getKey();
            Assert.notNull(object3, "JWK map key cannot be null.");
            if (!(object3 instanceof String)) {
                object3 = "JWK map keys must be Strings. Encountered key '" + object3 + "' of type " + object3.getClass().getName() + ".";
                throw new IllegalArgumentException((String)object3);
            }
            object3 = (String)object3;
            object2.add(object3, entry.getValue());
        }
        object = (Jwk)object2.build();
        if (this.desiredType.isInstance(object)) {
            return (T)((Jwk)this.desiredType.cast(object));
        }
        throw this.unexpectedIAE((Jwk<?>)object);
    }
}

