/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.security.DefaultJwkSet;
import io.jsonwebtoken.impl.security.JwkBuilderSupplier;
import io.jsonwebtoken.impl.security.JwkConverter;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Supplier;
import io.jsonwebtoken.security.DynamicJwkBuilder;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkSet;
import io.jsonwebtoken.security.KeyException;
import io.jsonwebtoken.security.MalformedKeySetException;
import io.jsonwebtoken.security.UnsupportedKeyException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class JwkSetConverter
implements Converter<JwkSet, Object> {
    private final Converter<Jwk<?>, Object> JWK_CONVERTER;
    private final Parameter<Set<Jwk<?>>> PARAM;
    private final boolean ignoreUnsupported;

    public JwkSetConverter() {
        this(JwkBuilderSupplier.DEFAULT, true);
    }

    public JwkSetConverter(boolean bl2) {
        this(JwkBuilderSupplier.DEFAULT, bl2);
    }

    public JwkSetConverter(Supplier<DynamicJwkBuilder<?, ?>> supplier, boolean bl2) {
        this(new JwkConverter(supplier), bl2);
    }

    public JwkSetConverter(Converter<Jwk<?>, Object> converter, boolean bl2) {
        this.JWK_CONVERTER = Assert.notNull(converter, "JWK converter cannot be null.");
        this.PARAM = DefaultJwkSet.param(converter);
        this.ignoreUnsupported = bl2;
    }

    public boolean isIgnoreUnsupported() {
        return this.ignoreUnsupported;
    }

    @Override
    public Object applyTo(JwkSet jwkSet) {
        return jwkSet;
    }

    @Override
    public JwkSet applyFrom(Object object) {
        Assert.notNull(object, "Value cannot be null.");
        if (object instanceof JwkSet) {
            return (JwkSet)object;
        }
        if (!(object instanceof Map)) {
            String string = "Value must be a Map<String,?> (JSON Object). Type found: " + object.getClass().getName() + ".";
            throw new IllegalArgumentException(string);
        }
        Map<String, Object> map = Collections.immutable((Map)object);
        if (Collections.isEmpty(map) || !map.containsKey(this.PARAM.getId())) {
            map = "Missing required " + this.PARAM + " parameter.";
            throw new MalformedKeySetException((String)((Object)map));
        }
        if ((map = map.get(this.PARAM.getId())) == null) {
            String string = "JWK Set " + this.PARAM + " value cannot be null.";
            throw new MalformedKeySetException(string);
        }
        if (!(map instanceof Collection)) {
            String string = "JWK Set " + this.PARAM + " value must be a Collection (JSON Array). Type found: " + map.getClass().getName();
            throw new MalformedKeySetException(string);
        }
        int n2 = Collections.size((Collection)((Object)map));
        if (n2 == 0) {
            String string = "JWK Set " + this.PARAM + " collection cannot be empty.";
            throw new MalformedKeySetException(string);
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(Collections.size((Map)object));
        for (Map.Entry entry : ((Map)object).entrySet()) {
            String string;
            Object object2 = Assert.notNull(entry.getKey(), "JWK Set map key cannot be null.");
            if (!(object2 instanceof String)) {
                string = "JWK Set map keys must be Strings. Encountered key '" + object2 + "' of type " + object2.getClass().getName();
                throw new IllegalArgumentException(string);
            }
            string = (String)object2;
            linkedHashMap.put(string, entry.getValue());
        }
        object = new LinkedHashSet(n2);
        int n3 = 0;
        for (String string : (Collection)((Object)map)) {
            block13: {
                try {
                    map = this.JWK_CONVERTER.applyFrom(string);
                    object.add(map);
                }
                catch (UnsupportedKeyException unsupportedKeyException) {
                    if (!this.ignoreUnsupported) {
                        object = "JWK Set keys[" + n3 + "]: " + unsupportedKeyException.getMessage();
                        throw new UnsupportedKeyException((String)object, unsupportedKeyException);
                    }
                }
                catch (KeyException | IllegalArgumentException runtimeException) {
                    if (this.ignoreUnsupported) break block13;
                    object = "JWK Set keys[" + n3 + "]: " + runtimeException.getMessage();
                    throw new MalformedKeySetException((String)object, runtimeException);
                }
            }
            ++n3;
        }
        linkedHashMap.remove(this.PARAM.getId());
        linkedHashMap.put(this.PARAM.getId(), object);
        return new DefaultJwkSet(this.PARAM, linkedHashMap);
    }
}

