/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.impl.security.JcaTemplate;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.SecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JwtX509StringConverter
implements Converter<X509Certificate, CharSequence> {
    public static final JwtX509StringConverter INSTANCE = new JwtX509StringConverter();

    @Override
    public String applyTo(X509Certificate object) {
        Object object2;
        Assert.notNull(object, "X509Certificate cannot be null.");
        try {
            object2 = ((Certificate)object).getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            object = "Unable to access X509Certificate encoded bytes necessary to perform DER Base64-encoding. Certificate: {" + object + "}. Cause: " + certificateEncodingException.getMessage();
            throw new IllegalArgumentException((String)object, certificateEncodingException);
        }
        if (Bytes.isEmpty(object2)) {
            object2 = "X509Certificate encoded bytes cannot be null or empty.  Certificate: {" + object + "}.";
            throw new IllegalArgumentException((String)object2);
        }
        return Encoders.BASE64.encode((byte[])object2);
    }

    protected X509Certificate toCert(byte[] byArray) throws SecurityException {
        return new JcaTemplate("X.509").generateX509Certificate(byArray);
    }

    @Override
    public X509Certificate applyFrom(CharSequence charSequence) {
        Assert.hasText(charSequence, "X.509 Certificate encoded string cannot be null or empty.");
        try {
            byte[] byArray = Decoders.BASE64.decode(charSequence);
            return this.toCert(byArray);
        }
        catch (Exception exception) {
            charSequence = "Unable to convert Base64 String '" + charSequence + "' to X509Certificate instance. Cause: " + exception.getMessage();
            throw new IllegalArgumentException((String)charSequence, exception);
        }
    }
}

