/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.lang.Assert;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;

public final class KeyPairs {
    private KeyPairs() {
    }

    private static String familyPrefix(Class<?> clazz) {
        if (RSAKey.class.isAssignableFrom(clazz)) {
            return "RSA ";
        }
        if (ECKey.class.isAssignableFrom(clazz)) {
            return "EC ";
        }
        return "";
    }

    public static <K> K getKey(KeyPair serializable, Class<K> clazz) {
        Assert.notNull(serializable, "KeyPair cannot be null.");
        String string = KeyPairs.familyPrefix(clazz) + "KeyPair ";
        boolean bl2 = PrivateKey.class.isAssignableFrom(clazz);
        serializable = bl2 ? serializable.getPrivate() : serializable.getPublic();
        return KeyPairs.assertKey((Key)serializable, clazz, string);
    }

    public static <K> K assertKey(Key object, Class<K> clazz, String string) {
        String string2;
        Assert.notNull(object, "Key argument cannot be null.");
        Assert.notNull(clazz, "Class argument cannot be null.");
        String string3 = string2 = object instanceof PrivateKey ? "private" : "public";
        if (!clazz.isInstance(object)) {
            object = string + string2 + " key must be an instance of " + clazz.getName() + ". Type found: " + object.getClass().getName();
            throw new IllegalArgumentException((String)object);
        }
        return clazz.cast(object);
    }
}

