/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.impl.security.PasswordSpec;
import io.jsonwebtoken.impl.security.ProvidedPrivateKeyBuilder;
import io.jsonwebtoken.impl.security.ProvidedSecretKeyBuilder;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeySupplier;
import io.jsonwebtoken.security.Password;
import io.jsonwebtoken.security.PrivateKeyBuilder;
import io.jsonwebtoken.security.SecretKeyBuilder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import javax.crypto.SecretKey;

public final class KeysBridge {
    private static final String GENERIC_SECRET_ALG_PREFIX = "Generic";

    private KeysBridge() {
    }

    public static Password password(char[] cArray) {
        return new PasswordSpec(cArray);
    }

    public static SecretKeyBuilder builder(SecretKey secretKey) {
        return new ProvidedSecretKeyBuilder(secretKey);
    }

    public static PrivateKeyBuilder builder(PrivateKey privateKey) {
        return new ProvidedPrivateKeyBuilder(privateKey);
    }

    public static <K extends Key> K root(K k2) {
        if (k2 instanceof KeySupplier) {
            return KeysBridge.root((KeySupplier)((Object)k2));
        }
        return k2;
    }

    public static <K extends Key> K root(KeySupplier<K> keySupplier) {
        Assert.notNull(keySupplier, "KeySupplier canot be null.");
        return (K)((Key)Assert.notNull(KeysBridge.root(keySupplier.getKey()), "KeySupplier key cannot be null."));
    }

    public static String findAlgorithm(Key key) {
        if (key != null) {
            return Strings.clean(key.getAlgorithm());
        }
        return null;
    }

    public static byte[] findEncoded(Key key) {
        Assert.notNull(key, "Key cannot be null.");
        byte[] byArray = null;
        try {
            byArray = key.getEncoded();
        }
        catch (Throwable throwable) {}
        return byArray;
    }

    public static boolean isGenericSecret(Key object) {
        if (!(object instanceof SecretKey)) {
            return false;
        }
        object = Assert.hasText(object.getAlgorithm(), "Key algorithm cannot be null or empty.");
        return ((String)object).startsWith(GENERIC_SECRET_ALG_PREFIX);
    }

    public static int findBitLength(Key object) {
        int n2 = -1;
        if (object instanceof SecretKey) {
            if ("RAW".equals((object = (SecretKey)object).getFormat())) {
                byte[] byArray = KeysBridge.findEncoded((Key)object);
                object = byArray;
                if (!Bytes.isEmpty(byArray)) {
                    n2 = (int)Bytes.bitLength((byte[])object);
                    Bytes.clear((byte[])object);
                }
            }
        } else if (object instanceof RSAKey) {
            object = (RSAKey)object;
            n2 = object.getModulus().bitLength();
        } else if (object instanceof ECKey) {
            object = (ECKey)object;
            n2 = object.getParams().getOrder().bitLength();
        } else if ((object = EdwardsCurve.findByKey((Key)object)) != null) {
            n2 = ((EdwardsCurve)object).getKeyBitLength();
        }
        return n2;
    }

    public static byte[] getEncoded(Key object) {
        Object object2;
        Assert.notNull(object, "Key cannot be null.");
        try {
            object2 = object.getEncoded();
        }
        catch (Throwable throwable) {
            object = "Cannot obtain required encoded bytes from key [" + KeysBridge.toString((Key)object) + "]: " + throwable.getMessage();
            throw new InvalidKeyException((String)object, throwable);
        }
        if (Bytes.isEmpty(object2)) {
            object2 = "Missing required encoded bytes for key [" + KeysBridge.toString((Key)object) + "].";
            throw new InvalidKeyException((String)object2);
        }
        return object2;
    }

    public static String toString(Key key) {
        if (key == null) {
            return "null";
        }
        if (key instanceof PublicKey) {
            return key.toString();
        }
        return "class: " + key.getClass().getName() + ", algorithm: " + key.getAlgorithm() + ", format: " + key.getFormat();
    }
}

