/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.VerifySecureDigestRequest;
import java.io.InputStream;
import java.security.Key;

final class NoneSignatureAlgorithm
implements SecureDigestAlgorithm<Key, Key> {
    private static final String ID = "none";
    static final SecureDigestAlgorithm<Key, Key> INSTANCE = new NoneSignatureAlgorithm();

    private NoneSignatureAlgorithm() {
    }

    @Override
    public final String getId() {
        return ID;
    }

    @Override
    public final byte[] digest(SecureRequest<InputStream, Key> secureRequest) throws SecurityException {
        throw new SignatureException("The 'none' algorithm cannot be used to create signatures.");
    }

    @Override
    public final boolean verify(VerifySecureDigestRequest<Key> verifySecureDigestRequest) throws SignatureException {
        throw new SignatureException("The 'none' algorithm cannot be used to verify signatures.");
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof SecureDigestAlgorithm && ID.equalsIgnoreCase(((SecureDigestAlgorithm)object).getId());
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public final String toString() {
        return ID;
    }
}

