/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import io.jsonwebtoken.impl.security.DefaultOctetPublicJwk;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.UnsupportedKeyException;
import java.security.Key;
import java.util.Set;

public abstract class OctetJwkFactory<K extends Key, J extends Jwk<K>>
extends AbstractFamilyJwkFactory<K, J> {
    OctetJwkFactory(Class<K> clazz, Set<Parameter<?>> set) {
        super("OKP", clazz, set);
    }

    @Override
    public boolean supports(Key key) {
        return super.supports(key) && EdwardsCurve.isEdwards(key);
    }

    protected static EdwardsCurve getCurve(ParameterReadable object) throws UnsupportedKeyException {
        Parameter<String> parameter = DefaultOctetPublicJwk.CRV;
        EdwardsCurve edwardsCurve = EdwardsCurve.findById((String)(object = object.get(parameter)));
        if (edwardsCurve == null) {
            object = "Unrecognized OKP JWK " + parameter + " value '" + (String)object + "'";
            throw new UnsupportedKeyException((String)object);
        }
        return edwardsCurve;
    }
}

