/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.DefaultJwkContext;
import io.jsonwebtoken.impl.security.DefaultOctetPrivateJwk;
import io.jsonwebtoken.impl.security.DefaultOctetPublicJwk;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.OctetJwkFactory;
import io.jsonwebtoken.impl.security.OctetPublicJwkFactory;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.OctetPrivateJwk;
import io.jsonwebtoken.security.OctetPublicJwk;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;

public class OctetPrivateJwkFactory
extends OctetJwkFactory<PrivateKey, OctetPrivateJwk<PrivateKey, PublicKey>> {
    public OctetPrivateJwkFactory() {
        super(PrivateKey.class, DefaultOctetPrivateJwk.PARAMS);
    }

    @Override
    protected boolean supportsKeyValues(JwkContext<?> jwkContext) {
        return super.supportsKeyValues(jwkContext) && jwkContext.containsKey(DefaultOctetPrivateJwk.D.getId());
    }

    @Override
    protected OctetPrivateJwk<PrivateKey, PublicKey> createJwkFromKey(JwkContext<PrivateKey> jwkContext) {
        Object object = Assert.notNull(jwkContext.getKey(), "PrivateKey cannot be null.");
        EdwardsCurve edwardsCurve = EdwardsCurve.forKey((Key)object);
        Object object2 = jwkContext.getPublicKey();
        if (object2 != null) {
            if (!edwardsCurve.equals(EdwardsCurve.forKey((Key)object2))) {
                String string = "Specified Edwards Curve PublicKey does not match the specified PrivateKey's curve.";
                throw new InvalidKeyException(string);
            }
        } else {
            object2 = EdwardsCurve.derivePublic((PrivateKey)object);
        }
        boolean bl2 = !Strings.hasText(jwkContext.getId()) && jwkContext.getIdThumbprintAlgorithm() != null;
        object2 = OctetPublicJwkFactory.INSTANCE.newContext(jwkContext, (Key)object2);
        object2 = (OctetPublicJwk)OctetPublicJwkFactory.INSTANCE.createJwk(object2);
        jwkContext.putAll(object2);
        if (bl2) {
            jwkContext.setId(object2.getId());
        }
        byte[] byArray = edwardsCurve.getKeyMaterial((Key)object);
        object = byArray;
        Assert.notEmpty(byArray, "Edwards PrivateKey 'd' value cannot be null or empty.");
        OctetPrivateJwkFactory.put(jwkContext, DefaultOctetPrivateJwk.D, object);
        return new DefaultOctetPrivateJwk<PrivateKey, PublicKey>(jwkContext, (OctetPublicJwk<PublicKey>)object2);
    }

    @Override
    protected OctetPrivateJwk<PrivateKey, PublicKey> createJwkFromValues(JwkContext<PrivateKey> jwkContext) {
        Object object = new RequiredParameterReader(jwkContext);
        EdwardsCurve edwardsCurve = OctetPrivateJwkFactory.getCurve((ParameterReadable)object);
        Map<String, Object> map = new DefaultJwkContext(DefaultOctetPublicJwk.PARAMS, jwkContext);
        map = OctetPublicJwkFactory.INSTANCE.createJwkFromValues((JwkContext)map);
        object = object.get(DefaultOctetPrivateJwk.D);
        object = edwardsCurve.toPrivateKey((byte[])object, jwkContext.getProvider());
        jwkContext.setKey((PrivateKey)object);
        return new DefaultOctetPrivateJwk<PrivateKey, PublicKey>(jwkContext, (OctetPublicJwk<PublicKey>)map);
    }
}

