/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.DefaultJweHeader;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.AesWrapKeyAlgorithm;
import io.jsonwebtoken.impl.security.CryptoAlgorithm;
import io.jsonwebtoken.impl.security.DefaultDecryptionKeyRequest;
import io.jsonwebtoken.impl.security.DefaultKeyRequest;
import io.jsonwebtoken.impl.security.Pbes2HsAkwAlgorithm$1;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.DecryptionKeyRequest;
import io.jsonwebtoken.security.KeyAlgorithm;
import io.jsonwebtoken.security.KeyRequest;
import io.jsonwebtoken.security.KeyResult;
import io.jsonwebtoken.security.Message;
import io.jsonwebtoken.security.Password;
import io.jsonwebtoken.security.Request;
import io.jsonwebtoken.security.SecurityException;
import java.nio.charset.StandardCharsets;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class Pbes2HsAkwAlgorithm
extends CryptoAlgorithm
implements KeyAlgorithm<Password, Password> {
    private static final int DEFAULT_SHA256_ITERATIONS = 310000;
    private static final int DEFAULT_SHA384_ITERATIONS = 210000;
    private static final int DEFAULT_SHA512_ITERATIONS = 120000;
    private static final int MIN_RECOMMENDED_ITERATIONS = 1000;
    private static final String MIN_ITERATIONS_MSG_PREFIX = "[JWA RFC 7518, Section 4.8.1.2](https://www.rfc-editor.org/rfc/rfc7518.html#section-4.8.1.2) recommends password-based-encryption iterations be greater than or equal to 1000. Provided: ";
    private static final double MAX_ITERATIONS_FACTOR = 2.5;
    private final int HASH_BYTE_LENGTH;
    private final int DERIVED_KEY_BIT_LENGTH;
    private final byte[] SALT_PREFIX;
    private final int DEFAULT_ITERATIONS;
    private final int MAX_ITERATIONS;
    private final KeyAlgorithm<SecretKey, SecretKey> wrapAlg;

    private static byte[] toRfcSaltPrefix(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    private static int hashBitLength(int n2) {
        return n2 << 1;
    }

    private static String idFor(int n2, KeyAlgorithm<SecretKey, SecretKey> keyAlgorithm) {
        Assert.notNull(keyAlgorithm, "wrapAlg argument cannot be null.");
        return "PBES2-HS" + n2 + "+" + keyAlgorithm.getId();
    }

    public static int assertIterations(int n2) {
        if (n2 < 1000) {
            String string = MIN_ITERATIONS_MSG_PREFIX + n2;
            throw new IllegalArgumentException(string);
        }
        return n2;
    }

    public Pbes2HsAkwAlgorithm(int n2) {
        this(Pbes2HsAkwAlgorithm.hashBitLength(n2), new AesWrapKeyAlgorithm(n2));
    }

    protected Pbes2HsAkwAlgorithm(int n2, KeyAlgorithm<SecretKey, SecretKey> keyAlgorithm) {
        super(Pbes2HsAkwAlgorithm.idFor(n2, keyAlgorithm), "PBKDF2WithHmacSHA" + n2);
        this.wrapAlg = keyAlgorithm;
        this.HASH_BYTE_LENGTH = n2 / 8;
        this.DEFAULT_ITERATIONS = n2 >= 512 ? 120000 : (n2 >= 384 ? 210000 : 310000);
        this.MAX_ITERATIONS = (int)((double)this.DEFAULT_ITERATIONS * 2.5);
        this.DERIVED_KEY_BIT_LENGTH = n2 / 2;
        this.SALT_PREFIX = Pbes2HsAkwAlgorithm.toRfcSaltPrefix(this.getId().getBytes(StandardCharsets.UTF_8));
    }

    protected SecretKey deriveKey(SecretKeyFactory object, char[] object2, byte[] byArray, int n2) throws Exception {
        object2 = new PBEKeySpec((char[])object2, byArray, n2, this.DERIVED_KEY_BIT_LENGTH);
        try {
            object = ((SecretKeyFactory)object).generateSecret((KeySpec)object2);
            object = new SecretKeySpec(object.getEncoded(), "AES");
            return object;
        }
        finally {
            ((PBEKeySpec)object2).clearPassword();
        }
    }

    private SecretKey deriveKey(KeyRequest<?> object, char[] cArray, byte[] byArray, int n2) {
        try {
            Assert.notEmpty(cArray, "Key password character array cannot be null or empty.");
            object = this.jca((Request<?>)object).withSecretKeyFactory(new Pbes2HsAkwAlgorithm$1(this, cArray, byArray, n2));
            return object;
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
    }

    protected byte[] generateInputSalt(KeyRequest<?> keyRequest) {
        byte[] byArray = new byte[this.HASH_BYTE_LENGTH];
        Pbes2HsAkwAlgorithm.ensureSecureRandom(keyRequest).nextBytes(byArray);
        return byArray;
    }

    protected byte[] toRfcSalt(byte[] byArray) {
        return Bytes.concat(this.SALT_PREFIX, byArray);
    }

    @Override
    public KeyResult getEncryptionKey(KeyRequest<Password> keyRequest) throws SecurityException {
        Assert.notNull(keyRequest, "request cannot be null.");
        Message<Object> message = (Password)Assert.notNull(keyRequest.getPayload(), "Encryption Password cannot be null.");
        JweHeader jweHeader = Assert.notNull(keyRequest.getHeader(), "JweHeader cannot be null.");
        Object object = jweHeader.getPbes2Count();
        if (object == null) {
            object = this.DEFAULT_ITERATIONS;
            jweHeader.put(DefaultJweHeader.P2C.getId(), object);
        }
        int n2 = Pbes2HsAkwAlgorithm.assertIterations((Integer)object);
        object = this.generateInputSalt(keyRequest);
        byte[] byArray = this.toRfcSalt((byte[])object);
        message = (Message<Object>)message.toCharArray();
        message = this.deriveKey(keyRequest, (char[])message, byArray, n2);
        message = new DefaultKeyRequest<Object>(message, keyRequest.getProvider(), keyRequest.getSecureRandom(), keyRequest.getHeader(), keyRequest.getEncryptionAlgorithm());
        message = this.wrapAlg.getEncryptionKey((KeyRequest<SecretKey>)message);
        keyRequest.getHeader().put(DefaultJweHeader.P2S.getId(), object);
        return message;
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<Password> decryptionKeyRequest) throws SecurityException {
        JweHeader jweHeader = Assert.notNull(decryptionKeyRequest.getHeader(), "Request JweHeader cannot be null.");
        Object object = (Password)Assert.notNull(decryptionKeyRequest.getKey(), "Decryption Password cannot be null.");
        RequiredParameterReader requiredParameterReader = new RequiredParameterReader(jweHeader);
        Object object2 = requiredParameterReader.get(DefaultJweHeader.P2S);
        Parameter<Integer> parameter = DefaultJweHeader.P2C;
        int n2 = requiredParameterReader.get(parameter);
        if (n2 > this.MAX_ITERATIONS) {
            object2 = "JWE Header " + parameter + " value " + n2 + " exceeds " + this.getId() + " maximum allowed value " + this.MAX_ITERATIONS + ". The larger value is rejected to help mitigate potential Denial of Service attacks.";
            throw new UnsupportedJwtException((String)object2);
        }
        object2 = Bytes.concat(new byte[][]{this.SALT_PREFIX, object2});
        object = object.toCharArray();
        object = this.deriveKey((KeyRequest<?>)decryptionKeyRequest, (char[])object, (byte[])object2, n2);
        decryptionKeyRequest = new DefaultDecryptionKeyRequest<Object>((byte[])decryptionKeyRequest.getPayload(), decryptionKeyRequest.getProvider(), decryptionKeyRequest.getSecureRandom(), jweHeader, decryptionKeyRequest.getEncryptionAlgorithm(), object);
        return this.wrapAlg.getDecryptionKey(decryptionKeyRequest);
    }
}

