/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import io.jsonwebtoken.impl.security.DefaultJwkContext;
import io.jsonwebtoken.impl.security.DefaultRsaPrivateJwk;
import io.jsonwebtoken.impl.security.DefaultRsaPublicJwk;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.impl.security.RsaPrivateJwkFactory$1;
import io.jsonwebtoken.impl.security.RsaPrivateJwkFactory$2;
import io.jsonwebtoken.impl.security.RsaPublicJwkFactory;
import io.jsonwebtoken.lang.Arrays;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.RsaPrivateJwk;
import io.jsonwebtoken.security.RsaPublicJwk;
import io.jsonwebtoken.security.UnsupportedKeyException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Map;
import java.util.Set;

class RsaPrivateJwkFactory
extends AbstractFamilyJwkFactory<RSAPrivateKey, RsaPrivateJwk> {
    private static final Set<Parameter<BigInteger>> OPTIONAL_PRIVATE_PARAMS = Collections.setOf(DefaultRsaPrivateJwk.FIRST_PRIME, DefaultRsaPrivateJwk.SECOND_PRIME, DefaultRsaPrivateJwk.FIRST_CRT_EXPONENT, DefaultRsaPrivateJwk.SECOND_CRT_EXPONENT, DefaultRsaPrivateJwk.FIRST_CRT_COEFFICIENT);
    private static final String PUBKEY_ERR_MSG = "JwkContext publicKey must be an " + RSAPublicKey.class.getName() + " instance.";
    private static final String PUB_EXPONENT_EX_MSG = "Unable to derive RSAPublicKey from RSAPrivateKey [%s]. Supported keys implement the " + RSAPrivateCrtKey.class.getName() + " or " + RSAMultiPrimePrivateCrtKey.class.getName() + " interfaces.  If the specified RSAPrivateKey cannot be one of these two, you must explicitly provide an RSAPublicKey in addition to the RSAPrivateKey, as the " + "[JWA RFC, Section 6.3.2](https://www.rfc-editor.org/rfc/rfc7518.html#section-6.3.2) requires public values to be present in private RSA JWKs.";

    RsaPrivateJwkFactory() {
        super("RSA", RSAPrivateKey.class, DefaultRsaPrivateJwk.PARAMS);
    }

    @Override
    protected boolean supportsKeyValues(JwkContext<?> jwkContext) {
        return super.supportsKeyValues(jwkContext) && jwkContext.containsKey(DefaultRsaPrivateJwk.PRIVATE_EXPONENT.getId());
    }

    private static BigInteger getPublicExponent(RSAPrivateKey object) {
        if (object instanceof RSAPrivateCrtKey) {
            return ((RSAPrivateCrtKey)object).getPublicExponent();
        }
        if (object instanceof RSAMultiPrimePrivateCrtKey) {
            return ((RSAMultiPrimePrivateCrtKey)object).getPublicExponent();
        }
        object = String.format(PUB_EXPONENT_EX_MSG, KeysBridge.toString((Key)object));
        throw new UnsupportedKeyException((String)object);
    }

    private RSAPublicKey derivePublic(JwkContext<RSAPrivateKey> jwkContext) {
        Object object = jwkContext.getKey();
        BigInteger bigInteger = object.getModulus();
        object = RsaPrivateJwkFactory.getPublicExponent((RSAPrivateKey)object);
        object = new RSAPublicKeySpec(bigInteger, (BigInteger)object);
        return this.generateKey(jwkContext, RSAPublicKey.class, new RsaPrivateJwkFactory$1(this, (RSAPublicKeySpec)object, jwkContext));
    }

    @Override
    protected RsaPrivateJwk createJwkFromKey(JwkContext<RSAPrivateKey> jwkContext) {
        Object object = jwkContext.getKey();
        Object object2 = jwkContext.getPublicKey();
        object2 = object2 != null ? Assert.isInstanceOf(RSAPublicKey.class, object2, PUBKEY_ERR_MSG) : this.derivePublic(jwkContext);
        boolean bl2 = !Strings.hasText(jwkContext.getId()) && jwkContext.getIdThumbprintAlgorithm() != null;
        object2 = RsaPublicJwkFactory.INSTANCE.newContext(jwkContext, object2);
        object2 = (RsaPublicJwk)RsaPublicJwkFactory.INSTANCE.createJwk(object2);
        jwkContext.putAll(object2);
        if (bl2) {
            jwkContext.setId(object2.getId());
        }
        RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.PRIVATE_EXPONENT, object.getPrivateExponent());
        if (object instanceof RSAPrivateCrtKey) {
            object = (RSAPrivateCrtKey)object;
            RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.FIRST_PRIME, object.getPrimeP());
            RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.SECOND_PRIME, object.getPrimeQ());
            RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.FIRST_CRT_EXPONENT, object.getPrimeExponentP());
            RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.SECOND_CRT_EXPONENT, object.getPrimeExponentQ());
            RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.FIRST_CRT_COEFFICIENT, object.getCrtCoefficient());
        } else if (object instanceof RSAMultiPrimePrivateCrtKey) {
            object = (RSAMultiPrimePrivateCrtKey)object;
            RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.FIRST_PRIME, object.getPrimeP());
            RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.SECOND_PRIME, object.getPrimeQ());
            RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.FIRST_CRT_EXPONENT, object.getPrimeExponentP());
            RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.SECOND_CRT_EXPONENT, object.getPrimeExponentQ());
            RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.FIRST_CRT_COEFFICIENT, object.getCrtCoefficient());
            object = Arrays.asList(object.getOtherPrimeInfo());
            if (!Collections.isEmpty(object)) {
                RsaPrivateJwkFactory.put(jwkContext, DefaultRsaPrivateJwk.OTHER_PRIMES_INFO, object);
            }
        }
        return new DefaultRsaPrivateJwk(jwkContext, (RsaPublicJwk)object2);
    }

    @Override
    protected RsaPrivateJwk createJwkFromValues(JwkContext<RSAPrivateKey> jwkContext) {
        Object object;
        Parameter<BigInteger> parameter2;
        Object object2 = new RequiredParameterReader(jwkContext);
        BigInteger bigInteger = object2.get(DefaultRsaPrivateJwk.PRIVATE_EXPONENT);
        Map<String, Object> map = new DefaultJwkContext(DefaultRsaPublicJwk.PARAMS, jwkContext);
        map = RsaPublicJwkFactory.INSTANCE.createJwkFromValues((JwkContext)map);
        Serializable serializable = (RSAPublicKey)map.toKey();
        BigInteger bigInteger2 = serializable.getModulus();
        serializable = serializable.getPublicExponent();
        boolean bl2 = false;
        for (Parameter<BigInteger> parameter2 : OPTIONAL_PRIVATE_PARAMS) {
            if (!jwkContext.containsKey(parameter2.getId())) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            parameter2 = object2.get(DefaultRsaPrivateJwk.FIRST_PRIME);
            BigInteger bigInteger3 = object2.get(DefaultRsaPrivateJwk.SECOND_PRIME);
            object = object2.get(DefaultRsaPrivateJwk.FIRST_CRT_EXPONENT);
            BigInteger bigInteger4 = object2.get(DefaultRsaPrivateJwk.SECOND_CRT_EXPONENT);
            BigInteger bigInteger5 = object2.get(DefaultRsaPrivateJwk.FIRST_CRT_COEFFICIENT);
            if (jwkContext.containsKey(DefaultRsaPrivateJwk.OTHER_PRIMES_INFO.getId())) {
                object2 = object2.get(DefaultRsaPrivateJwk.OTHER_PRIMES_INFO);
                RSAOtherPrimeInfo[] rSAOtherPrimeInfoArray = new RSAOtherPrimeInfo[Collections.size(object2)];
                rSAOtherPrimeInfoArray = object2.toArray(rSAOtherPrimeInfoArray);
                object = new RSAMultiPrimePrivateCrtKeySpec(bigInteger2, (BigInteger)serializable, bigInteger, (BigInteger)((Object)parameter2), bigInteger3, (BigInteger)object, bigInteger4, bigInteger5, rSAOtherPrimeInfoArray);
            } else {
                object = new RSAPrivateCrtKeySpec(bigInteger2, (BigInteger)serializable, bigInteger, (BigInteger)((Object)parameter2), bigInteger3, (BigInteger)object, bigInteger4, bigInteger5);
            }
        } else {
            object = new RSAPrivateKeySpec(bigInteger2, bigInteger);
        }
        parameter2 = this.generateFromSpec(jwkContext, (KeySpec)object);
        jwkContext.setKey((RSAPrivateKey)((Object)parameter2));
        return new DefaultRsaPrivateJwk(jwkContext, (RsaPublicJwk)map);
    }

    protected RSAPrivateKey generateFromSpec(JwkContext<RSAPrivateKey> jwkContext, KeySpec keySpec) {
        return this.generateKey(jwkContext, new RsaPrivateJwkFactory$2(this, keySpec));
    }
}

