/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.Jwts$ENC;
import io.jsonwebtoken.Jwts$KEY;
import io.jsonwebtoken.Jwts$SIG;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import io.jsonwebtoken.impl.security.AbstractJwk;
import io.jsonwebtoken.impl.security.AesAlgorithm;
import io.jsonwebtoken.impl.security.CryptoAlgorithm;
import io.jsonwebtoken.impl.security.DefaultMacAlgorithm;
import io.jsonwebtoken.impl.security.DefaultSecretJwk;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.AeadAlgorithm;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.MacAlgorithm;
import io.jsonwebtoken.security.MalformedKeyException;
import io.jsonwebtoken.security.SecretJwk;
import io.jsonwebtoken.security.SecretKeyAlgorithm;
import io.jsonwebtoken.security.WeakKeyException;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class SecretJwkFactory
extends AbstractFamilyJwkFactory<SecretKey, SecretJwk> {
    SecretJwkFactory() {
        super("oct", SecretKey.class, DefaultSecretJwk.PARAMS);
    }

    @Override
    protected SecretJwk createJwkFromKey(JwkContext<SecretKey> object) {
        String string;
        Object object2 = Assert.notNull(object.getKey(), "JwkContext key cannot be null.");
        byte[] byArray = null;
        try {
            byArray = KeysBridge.getEncoded((Key)object2);
            string = Encoders.BASE64URL.encode(byArray);
            Assert.hasText(string, "k value cannot be null or empty.");
        }
        catch (Throwable throwable) {
            object = "Unable to encode SecretKey to JWK: " + throwable.getMessage();
            throw new InvalidKeyException((String)object, throwable);
        }
        finally {
            Bytes.clear(byArray);
        }
        object2 = DefaultMacAlgorithm.findByKey((Key)object2);
        if (object2 != null) {
            object.put(AbstractJwk.ALG.getId(), object2.getId());
        }
        object.put(DefaultSecretJwk.K.getId(), string);
        return this.createJwkFromValues((JwkContext)object);
    }

    private static void assertKeyBitLength(byte[] object, MacAlgorithm macAlgorithm) {
        long l2;
        long l3 = Bytes.bitLength(object);
        if (l3 < (l2 = (long)macAlgorithm.getKeyBitLength())) {
            object = "Secret JWK " + AbstractJwk.ALG + " value is '" + macAlgorithm.getId() + "', but the " + DefaultSecretJwk.K + " length is smaller than the " + macAlgorithm.getId() + " minimum length of " + Bytes.bitsMsg(l2) + " required by [JWA RFC 7518, Section 3.2](https://www.rfc-editor.org/rfc/rfc7518.html#section-3.2), " + "2nd paragraph: 'A key of the same size as the hash output or larger MUST be used with this algorithm.'";
            throw new WeakKeyException((String)object);
        }
    }

    private static void assertSymmetric(Identifiable object) {
        if (object instanceof MacAlgorithm || object instanceof SecretKeyAlgorithm || object instanceof AeadAlgorithm) {
            return;
        }
        object = "Invalid Secret JWK " + AbstractJwk.ALG + " value '" + object.getId() + "'. Secret JWKs may only be used with symmetric (secret) key algorithms.";
        throw new MalformedKeyException((String)object);
    }

    @Override
    protected SecretJwk createJwkFromValues(JwkContext<SecretKey> jwkContext) {
        Object object = new RequiredParameterReader(jwkContext);
        object = object.get(DefaultSecretJwk.K);
        String string = jwkContext.getAlgorithm();
        if (!Strings.hasText(string)) {
            int n2 = (int)Bytes.bitLength((byte[])object);
            object = jwkContext.isSigUse() || n2 > Jwts$SIG.HS256.getKeyBitLength() ? Keys.hmacShaKeyFor((byte[])object) : AesAlgorithm.keyFor((byte[])object);
            jwkContext.setKey((SecretKey)object);
            return new DefaultSecretJwk(jwkContext);
        }
        Identifiable identifiable = (Identifiable)Jwts$SIG.get().get(string);
        if (identifiable == null) {
            identifiable = (Identifiable)Jwts$KEY.get().get(string);
        }
        if (identifiable == null) {
            identifiable = (Identifiable)Jwts$ENC.get().get(string);
        }
        if (identifiable != null) {
            SecretJwkFactory.assertSymmetric(identifiable);
        }
        if (identifiable instanceof MacAlgorithm) {
            SecretJwkFactory.assertKeyBitLength((byte[])object, (MacAlgorithm)identifiable);
            string = ((CryptoAlgorithm)identifiable).getJcaName();
            Assert.hasText(string, "Algorithm jcaName cannot be null or empty.");
            object = new SecretKeySpec((byte[])object, string);
        } else {
            object = AesAlgorithm.keyFor((byte[])object);
        }
        jwkContext.setKey((SecretKey)object);
        return new DefaultSecretJwk(jwkContext);
    }
}

